/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class AllEntriesTable
extends BaseMetadataTable {
    AllEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_entries");
    }

    AllEntriesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    public TableScan newScan() {
        return new Scan(this.operations(), this.table(), this.schema());
    }

    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{102}));
        }
        return schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_ENTRIES;
    }

    private static class Scan
    extends BaseAllMetadataTableScan {
        Scan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema, MetadataTableType.ALL_ENTRIES);
        }

        private Scan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, MetadataTableType.ALL_ENTRIES, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new Scan(ops, table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            CloseableIterable<ManifestFile> manifests = this.reachableManifests((Function<Snapshot, Iterable<ManifestFile>>)((Function)snapshot -> snapshot.allManifests(this.tableOps().io())));
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            True filter = this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter();
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned((Expression)filter);
            return CloseableIterable.transform(manifests, manifest -> new ManifestEntriesTable.ManifestReadTask(this.table(), (ManifestFile)manifest, this.schema(), schemaString, specString, residuals));
        }
    }
}

