/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.Scan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;

abstract class BaseScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
implements Scan<ThisT, T, G> {
    private final TableOperations ops;
    private final Table table;
    private final Schema schema;
    private final TableScanContext context;

    protected BaseScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        this.ops = ops;
        this.table = table;
        this.schema = schema;
        this.context = context;
    }

    protected TableOperations tableOps() {
        return this.ops;
    }

    protected Table table() {
        return this.table;
    }

    protected Schema tableSchema() {
        return this.schema;
    }

    protected TableScanContext context() {
        return this.context;
    }

    protected abstract ThisT newRefinedScan(TableOperations var1, Table var2, Schema var3, TableScanContext var4);

    public ThisT option(String property, String value) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.withOption(property, value));
    }

    public ThisT project(Schema projectedSchema) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.project(projectedSchema));
    }

    public ThisT caseSensitive(boolean caseSensitive) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.setCaseSensitive(caseSensitive));
    }

    public ThisT includeColumnStats() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.shouldReturnColumnStats(true));
    }

    public ThisT select(Collection<String> columns) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.selectColumns(columns));
    }

    public ThisT filter(Expression expr) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.filterRows(Expressions.and((Expression)this.context.rowFilter(), (Expression)expr)));
    }

    public ThisT ignoreResiduals() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.ignoreResiduals(true));
    }

    public ThisT planWith(ExecutorService executorService) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.planWith(executorService));
    }

    public Schema schema() {
        return BaseScan.lazyColumnProjection(this.context, this.schema);
    }

    public long targetSplitSize() {
        long tableValue = this.ops.current().propertyAsLong("read.split.target-size", 0x8000000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.target-size", tableValue);
    }

    public int splitLookback() {
        int tableValue = this.ops.current().propertyAsInt("read.split.planning-lookback", 10);
        return PropertyUtil.propertyAsInt(this.context.options(), "read.split.planning-lookback", tableValue);
    }

    public long splitOpenFileCost() {
        long tableValue = this.ops.current().propertyAsLong("read.split.open-file-cost", 0x400000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.open-file-cost", tableValue);
    }

    private static Schema lazyColumnProjection(TableScanContext context, Schema schema) {
        Collection<String> selectedColumns = context.selectedColumns();
        if (selectedColumns != null) {
            HashSet requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences((Types.StructType)schema.asStruct(), Collections.singletonList(context.rowFilter()), (boolean)context.caseSensitive()));
            Set selectedIds = context.caseSensitive() ? TypeUtil.getProjectedIds((Schema)schema.select(selectedColumns)) : TypeUtil.getProjectedIds((Schema)schema.caseInsensitiveSelect(selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.project((Schema)schema, (Set)requiredFieldIds);
        }
        if (context.projectedSchema() != null) {
            return context.projectedSchema();
        }
        return schema;
    }
}

