/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTableScan
extends BaseScan<TableScan, FileScanTask, CombinedScanTask>
implements TableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTableScan.class);

    protected BaseTableScan(TableOperations ops, Table table, Schema schema) {
        this(ops, table, schema, new TableScanContext());
    }

    protected BaseTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    protected Long snapshotId() {
        return this.context().snapshotId();
    }

    protected boolean colStats() {
        return this.context().returnColumnStats();
    }

    protected boolean shouldIgnoreResiduals() {
        return this.context().ignoreResiduals();
    }

    protected ExecutorService planExecutor() {
        return this.context().planExecutor();
    }

    protected Map<String, String> options() {
        return this.context().options();
    }

    protected abstract CloseableIterable<FileScanTask> doPlanFiles();

    @Override
    public Table table() {
        return super.table();
    }

    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    public TableScan useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (Object)this.snapshotId());
        Preconditions.checkArgument((this.tableOps().current().snapshot(scanSnapshotId) != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s", (long)scanSnapshotId);
        return (TableScan)this.newRefinedScan(this.tableOps(), this.table(), this.tableSchema(), this.context().useSnapshotId(scanSnapshotId));
    }

    public TableScan asOfTime(long timestampMillis) {
        Preconditions.checkArgument((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (Object)this.snapshotId());
        return this.useSnapshot(SnapshotUtil.snapshotIdAsOfTime(this.table(), timestampMillis));
    }

    public Expression filter() {
        return this.context().rowFilter();
    }

    public CloseableIterable<FileScanTask> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot != null) {
            LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table(), snapshot.snapshotId(), DateTimeUtil.formatTimestampMillis(snapshot.timestampMillis()), ExpressionUtil.toSanitizedString((Expression)this.filter())});
            Listeners.notifyAll((Object)new ScanEvent(this.table().name(), snapshot.snapshotId(), this.filter(), this.schema()));
            return this.doPlanFiles();
        }
        LOG.info("Scanning empty table {}", (Object)this.table());
        return CloseableIterable.empty();
    }

    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    public Snapshot snapshot() {
        return this.snapshotId() != null ? this.tableOps().current().snapshot(this.snapshotId()) : this.tableOps().current().currentSnapshot();
    }

    public boolean isCaseSensitive() {
        return this.context().caseSensitive();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table()).add("projection", (Object)this.schema().asStruct()).add("filter", (Object)this.filter()).add("ignoreResiduals", this.shouldIgnoreResiduals()).add("caseSensitive", this.isCaseSensitive()).toString();
    }
}

