/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalDataTableScan;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.SnapshotUtil;

public class DataTableScan
extends BaseTableScan {
    static final ImmutableList<String> SCAN_COLUMNS = ImmutableList.of((Object)"snapshot_id", (Object)"file_path", (Object)"file_ordinal", (Object)"file_format", (Object)"block_size_in_bytes", (Object)"file_size_in_bytes", (Object)"record_count", (Object)"partition", (Object)"key_metadata", (Object)"split_offsets");
    static final ImmutableList<String> SCAN_WITH_STATS_COLUMNS = ImmutableList.builder().addAll(SCAN_COLUMNS).add((Object[])new String[]{"value_counts", "null_value_counts", "nan_value_counts", "lower_bounds", "upper_bounds", "column_sizes"}).build();
    static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    public DataTableScan(TableOperations ops, Table table) {
        super(ops, table, table.schema());
    }

    protected DataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        Preconditions.checkState((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot enable incremental scan, scan-snapshot set to id=%s", (Object)this.snapshotId());
        return new IncrementalDataTableScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotIdExclusive(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState((currentSnapshot != null ? 1 : 0) != 0, (String)"Cannot scan appends after %s, there is no current snapshot", (long)fromSnapshotId);
        return this.appendsBetween(fromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        super.useSnapshot(scanSnapshotId);
        Schema snapshotSchema = SnapshotUtil.schemaFor(this.table(), scanSnapshotId);
        return this.newRefinedScan(this.tableOps(), this.table(), snapshotSchema, this.context().useSnapshotId(scanSnapshotId));
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new DataTableScan(ops, table, schema, context);
    }

    @Override
    public CloseableIterable<FileScanTask> doPlanFiles() {
        Snapshot snapshot = this.snapshot();
        FileIO io = this.table().io();
        ManifestGroup manifestGroup = new ManifestGroup(io, snapshot.dataManifests(io), snapshot.deleteManifests(io)).caseSensitive(this.isCaseSensitive()).select((List<String>)(this.colStats() ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS)).filterData(this.filter()).specsById(this.table().specs()).ignoreDeleted();
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (snapshot.dataManifests(io).size() > 1 && (PLAN_SCANS_WITH_WORKER_POOL || this.context().planWithCustomizedExecutor())) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }
}

