/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class MetadataColumns {
    public static final Types.NestedField FILE_PATH = Types.NestedField.required((int)0x7FFFFFFE, (String)"_file", (Type)Types.StringType.get(), (String)"Path of the file in which a row is stored");
    public static final Types.NestedField ROW_POSITION = Types.NestedField.required((int)0x7FFFFFFD, (String)"_pos", (Type)Types.LongType.get(), (String)"Ordinal position of a row in the source data file");
    public static final Types.NestedField IS_DELETED = Types.NestedField.required((int)0x7FFFFFFC, (String)"_deleted", (Type)Types.BooleanType.get(), (String)"Whether the row has been deleted");
    public static final Types.NestedField SPEC_ID = Types.NestedField.required((int)0x7FFFFFFB, (String)"_spec_id", (Type)Types.IntegerType.get(), (String)"Spec ID used to track the file containing a row");
    public static final int PARTITION_COLUMN_ID = 0x7FFFFFFA;
    public static final String PARTITION_COLUMN_NAME = "_partition";
    public static final String PARTITION_COLUMN_DOC = "Partition to which a row belongs to";
    public static final Types.NestedField DELETE_FILE_PATH = Types.NestedField.required((int)2147483546, (String)"file_path", (Type)Types.StringType.get(), (String)"Path of a file in which a deleted row is stored");
    public static final Types.NestedField DELETE_FILE_POS = Types.NestedField.required((int)0x7FFFFF99, (String)"pos", (Type)Types.LongType.get(), (String)"Ordinal position of a deleted row in the data file");
    public static final String DELETE_FILE_ROW_FIELD_NAME = "row";
    public static final int DELETE_FILE_ROW_FIELD_ID = 2147483544;
    public static final String DELETE_FILE_ROW_DOC = "Deleted row values";
    private static final Map<String, Types.NestedField> META_COLUMNS = ImmutableMap.of((Object)FILE_PATH.name(), (Object)FILE_PATH, (Object)ROW_POSITION.name(), (Object)ROW_POSITION, (Object)IS_DELETED.name(), (Object)IS_DELETED, (Object)SPEC_ID.name(), (Object)SPEC_ID);
    private static final Set<Integer> META_IDS = ImmutableSet.of((Object)FILE_PATH.fieldId(), (Object)ROW_POSITION.fieldId(), (Object)IS_DELETED.fieldId(), (Object)SPEC_ID.fieldId(), (Object)0x7FFFFFFA);

    private MetadataColumns() {
    }

    public static Set<Integer> metadataFieldIds() {
        return META_IDS;
    }

    public static Types.NestedField metadataColumn(Table table, String name) {
        if (name.equals(PARTITION_COLUMN_NAME)) {
            return Types.NestedField.optional((int)0x7FFFFFFA, (String)PARTITION_COLUMN_NAME, (Type)Partitioning.partitionType(table), (String)PARTITION_COLUMN_DOC);
        }
        return META_COLUMNS.get(name);
    }

    public static boolean isMetadataColumn(String name) {
        return name.equals(PARTITION_COLUMN_NAME) || META_COLUMNS.containsKey(name);
    }

    public static boolean nonMetadataColumn(String name) {
        return !MetadataColumns.isMetadataColumn(name);
    }
}

