/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.JsonUtil;

public class SnapshotParser {
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String PARENT_SNAPSHOT_ID = "parent-snapshot-id";
    private static final String TIMESTAMP_MS = "timestamp-ms";
    private static final String SUMMARY = "summary";
    private static final String OPERATION = "operation";
    private static final String MANIFESTS = "manifests";
    private static final String MANIFEST_LIST = "manifest-list";
    private static final String SCHEMA_ID = "schema-id";

    private SnapshotParser() {
    }

    static void toJson(Snapshot snapshot, JsonGenerator generator) throws IOException {
        String manifestList;
        generator.writeStartObject();
        if (snapshot.sequenceNumber() > 0L) {
            generator.writeNumberField(SEQUENCE_NUMBER, snapshot.sequenceNumber());
        }
        generator.writeNumberField(SNAPSHOT_ID, snapshot.snapshotId());
        if (snapshot.parentId() != null) {
            generator.writeNumberField(PARENT_SNAPSHOT_ID, snapshot.parentId().longValue());
        }
        generator.writeNumberField(TIMESTAMP_MS, snapshot.timestampMillis());
        if (snapshot.operation() != null) {
            generator.writeObjectFieldStart(SUMMARY);
            generator.writeStringField(OPERATION, snapshot.operation());
            if (snapshot.summary() != null) {
                for (Map.Entry entry : snapshot.summary().entrySet()) {
                    if (OPERATION.equals(entry.getKey())) continue;
                    generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
                }
            }
            generator.writeEndObject();
        }
        if ((manifestList = snapshot.manifestListLocation()) != null) {
            generator.writeStringField(MANIFEST_LIST, manifestList);
        } else {
            generator.writeArrayFieldStart(MANIFESTS);
            for (ManifestFile file : snapshot.allManifests()) {
                generator.writeString(file.path());
            }
            generator.writeEndArray();
        }
        if (snapshot.schemaId() != null) {
            generator.writeNumberField(SCHEMA_ID, snapshot.schemaId().intValue());
        }
        generator.writeEndObject();
    }

    public static String toJson(Snapshot snapshot) {
        return SnapshotParser.toJson(snapshot, true);
    }

    public static String toJson(Snapshot snapshot, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            SnapshotParser.toJson(snapshot, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write json for: %s", new Object[]{snapshot});
        }
    }

    static Snapshot fromJson(FileIO io, JsonNode node) {
        Preconditions.checkArgument((boolean)node.isObject(), (String)"Cannot parse table version from a non-object: %s", (Object)node);
        long sequenceNumber = 0L;
        if (node.has(SEQUENCE_NUMBER)) {
            sequenceNumber = JsonUtil.getLong(SEQUENCE_NUMBER, node);
        }
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        Long parentId = null;
        if (node.has(PARENT_SNAPSHOT_ID)) {
            parentId = JsonUtil.getLong(PARENT_SNAPSHOT_ID, node);
        }
        long timestamp = JsonUtil.getLong(TIMESTAMP_MS, node);
        ImmutableMap summary = null;
        String operation = null;
        if (node.has(SUMMARY)) {
            JsonNode sNode = node.get(SUMMARY);
            Preconditions.checkArgument((sNode != null && !sNode.isNull() && sNode.isObject() ? 1 : 0) != 0, (String)"Cannot parse summary from non-object value: %s", (Object)sNode);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Iterator fields = sNode.fieldNames();
            while (fields.hasNext()) {
                String field = (String)fields.next();
                if (field.equals(OPERATION)) {
                    operation = JsonUtil.getString(OPERATION, sNode);
                    continue;
                }
                builder.put((Object)field, (Object)JsonUtil.getString(field, sNode));
            }
            summary = builder.build();
        }
        Integer schemaId = JsonUtil.getIntOrNull(SCHEMA_ID, node);
        if (node.has(MANIFEST_LIST)) {
            String manifestList = JsonUtil.getString(MANIFEST_LIST, node);
            return new BaseSnapshot(io, sequenceNumber, snapshotId, parentId, timestamp, operation, (Map<String, String>)summary, schemaId, manifestList);
        }
        List manifests = Lists.transform(JsonUtil.getStringList(MANIFESTS, node), location -> new GenericManifestFile(io.newInputFile(location), 0));
        return new BaseSnapshot(io, snapshotId, parentId, timestamp, operation, (Map<String, String>)summary, schemaId, manifests);
    }

    public static Snapshot fromJson(FileIO io, String json) {
        try {
            return SnapshotParser.fromJson(io, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read version from json: %s", new Object[]{json});
        }
    }
}

