/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;

public class HTTPClientFactory
implements Function<Map<String, String>, RESTClient> {
    @VisibleForTesting
    static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    @VisibleForTesting
    static final String CLIENT_GIT_COMMIT_SHORT_HEADER = "X-Client-Git-Commit-Short";

    @Override
    public RESTClient apply(Map<String, String> properties) {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Invalid configuration: null");
        Preconditions.checkArgument((boolean)properties.containsKey("uri"), (Object)"REST Catalog server URI is required");
        String baseURI = properties.get("uri").trim();
        String clientVersion = IcebergBuild.fullVersion();
        String gitCommitShortId = IcebergBuild.gitCommitShortId();
        return HTTPClient.builder().withHeader(CLIENT_VERSION_HEADER, clientVersion).withHeader(CLIENT_GIT_COMMIT_SHORT_HEADER, gitCommitShortId).uri(baseURI).build();
    }
}

