/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.MetadataColumns;

public class IcebergColumnHandle
implements ColumnHandle {
    public static final int TRINO_UPDATE_ROW_ID = Integer.MIN_VALUE;
    public static final int TRINO_MERGE_ROW_ID = -2147483647;
    public static final String TRINO_ROW_ID_NAME = "$row_id";
    public static final int TRINO_MERGE_PARTITION_SPEC_ID = -2147483646;
    public static final int TRINO_MERGE_PARTITION_DATA = -2147483645;
    private final ColumnIdentity baseColumnIdentity;
    private final Type baseType;
    private final List<Integer> path;
    private final Type type;
    private final Optional<String> comment;
    private final int id;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="baseColumnIdentity") ColumnIdentity baseColumnIdentity, @JsonProperty(value="baseType") Type baseType, @JsonProperty(value="path") List<Integer> path, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment) {
        this.baseColumnIdentity = Objects.requireNonNull(baseColumnIdentity, "baseColumnIdentity is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.id = path.isEmpty() ? baseColumnIdentity.getId() : ((Integer)Iterables.getLast(path)).intValue();
    }

    @JsonIgnore
    public ColumnIdentity getColumnIdentity() {
        ColumnIdentity columnIdentity = this.baseColumnIdentity;
        for (int fieldId : this.path) {
            columnIdentity = columnIdentity.getChildByFieldId(fieldId);
        }
        return columnIdentity;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public ColumnIdentity getBaseColumnIdentity() {
        return this.baseColumnIdentity;
    }

    @JsonProperty
    public Type getBaseType() {
        return this.baseType;
    }

    @JsonIgnore
    public IcebergColumnHandle getBaseColumn() {
        return new IcebergColumnHandle(this.getBaseColumnIdentity(), this.getBaseType(), (List<Integer>)ImmutableList.of(), this.getBaseType(), Optional.empty());
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonIgnore
    public int getId() {
        return this.id;
    }

    @JsonIgnore
    public String getName() {
        return this.getColumnIdentity().getName();
    }

    @JsonProperty
    public List<Integer> getPath() {
        return this.path;
    }

    @JsonIgnore
    public String getQualifiedName() {
        ImmutableList.Builder pathNames = ImmutableList.builder();
        ColumnIdentity columnIdentity = this.baseColumnIdentity;
        pathNames.add((Object)columnIdentity.getName());
        for (int fieldId : this.path) {
            columnIdentity = columnIdentity.getChildByFieldId(fieldId);
            pathNames.add((Object)columnIdentity.getName());
        }
        return String.join((CharSequence)".", (Iterable<? extends CharSequence>)pathNames.build());
    }

    @JsonIgnore
    public boolean isBaseColumn() {
        return this.path.isEmpty();
    }

    @JsonIgnore
    public boolean isRowPositionColumn() {
        return this.id == MetadataColumns.ROW_POSITION.fieldId();
    }

    @JsonIgnore
    public boolean isUpdateRowIdColumn() {
        return this.id == Integer.MIN_VALUE;
    }

    @JsonIgnore
    public boolean isMergeRowIdColumn() {
        return this.id == -2147483647;
    }

    @JsonIgnore
    public boolean isIsDeletedColumn() {
        return this.id == MetadataColumns.IS_DELETED.fieldId();
    }

    @JsonIgnore
    public boolean isFileModifiedTimeColumn() {
        return this.id == IcebergMetadataColumn.FILE_MODIFIED_TIME.getId();
    }

    public int hashCode() {
        return Objects.hash(this.baseColumnIdentity, this.baseType, this.path, this.type, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)obj;
        return Objects.equals(this.baseColumnIdentity, other.baseColumnIdentity) && Objects.equals(this.baseType, other.baseType) && Objects.equals(this.path, other.path) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName();
    }

    public static IcebergColumnHandle pathColumnHandle() {
        return new IcebergColumnHandle(IcebergColumnHandle.columnIdentity(IcebergMetadataColumn.FILE_PATH), IcebergMetadataColumn.FILE_PATH.getType(), (List<Integer>)ImmutableList.of(), IcebergMetadataColumn.FILE_PATH.getType(), Optional.empty());
    }

    public static ColumnMetadata pathColumnMetadata() {
        return ColumnMetadata.builder().setName(IcebergMetadataColumn.FILE_PATH.getColumnName()).setType(IcebergMetadataColumn.FILE_PATH.getType()).setHidden(true).build();
    }

    public static IcebergColumnHandle fileModifiedTimeColumnHandle() {
        return new IcebergColumnHandle(IcebergColumnHandle.columnIdentity(IcebergMetadataColumn.FILE_MODIFIED_TIME), IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (List<Integer>)ImmutableList.of(), IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), Optional.empty());
    }

    public static ColumnMetadata fileModifiedTimeColumnMetadata() {
        return ColumnMetadata.builder().setName(IcebergMetadataColumn.FILE_MODIFIED_TIME.getColumnName()).setType(IcebergMetadataColumn.FILE_MODIFIED_TIME.getType()).setHidden(true).build();
    }

    private static ColumnIdentity columnIdentity(IcebergMetadataColumn metadata) {
        return new ColumnIdentity(metadata.getId(), metadata.getColumnName(), metadata.getTypeCategory(), (List<ColumnIdentity>)ImmutableList.of());
    }

    public boolean isPathColumn() {
        return this.getColumnIdentity().getId() == IcebergMetadataColumn.FILE_PATH.getId();
    }
}

