/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;

public enum IcebergErrorCode implements ErrorCodeSupplier
{
    ICEBERG_INVALID_METADATA(1, ErrorType.EXTERNAL),
    ICEBERG_TOO_MANY_OPEN_PARTITIONS(2, ErrorType.USER_ERROR),
    ICEBERG_INVALID_PARTITION_VALUE(3, ErrorType.EXTERNAL),
    ICEBERG_BAD_DATA(4, ErrorType.EXTERNAL),
    ICEBERG_CANNOT_OPEN_SPLIT(6, ErrorType.EXTERNAL),
    ICEBERG_WRITER_OPEN_ERROR(7, ErrorType.EXTERNAL),
    ICEBERG_FILESYSTEM_ERROR(8, ErrorType.EXTERNAL),
    ICEBERG_CURSOR_ERROR(9, ErrorType.EXTERNAL),
    ICEBERG_WRITE_VALIDATION_FAILED(10, ErrorType.INTERNAL_ERROR),
    ICEBERG_INVALID_SNAPSHOT_ID(11, ErrorType.USER_ERROR),
    ICEBERG_COMMIT_ERROR(12, ErrorType.EXTERNAL),
    ICEBERG_CATALOG_ERROR(13, ErrorType.EXTERNAL),
    ICEBERG_WRITER_CLOSE_ERROR(14, ErrorType.EXTERNAL),
    ICEBERG_MISSING_METADATA(15, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;

    private IcebergErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 0x5040000, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

