/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class IcebergInputInfo {
    private final Optional<Long> snapshotId;
    private final Optional<Boolean> partitioned;
    private final String tableDefaultFileFormat;

    @JsonCreator
    public IcebergInputInfo(@JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="partitioned") Optional<Boolean> partitioned, @JsonProperty(value="fileFormat") String tableDefaultFileFormat) {
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.partitioned = Objects.requireNonNull(partitioned, "partitioned is null");
        this.tableDefaultFileFormat = Objects.requireNonNull(tableDefaultFileFormat, "tableDefaultFileFormat is null");
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public Optional<Boolean> getPartitioned() {
        return this.partitioned;
    }

    @JsonProperty
    public String getTableDefaultFileFormat() {
        return this.tableDefaultFileFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergInputInfo)) {
            return false;
        }
        IcebergInputInfo that = (IcebergInputInfo)o;
        return this.partitioned.equals(that.partitioned) && this.snapshotId.equals(that.snapshotId) && this.tableDefaultFileFormat.equals(that.tableDefaultFileFormat);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.partitioned, this.tableDefaultFileFormat);
    }
}

