/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.schema.MessageType;

public class IcebergParquetFileWriter
extends ParquetFileWriter
implements IcebergFileWriter {
    private final MetricsConfig metricsConfig;
    private final InputFile inputFile;

    public IcebergParquetFileWriter(MetricsConfig metricsConfig, TrinoOutputFile outputFile, Closeable rollbackAction, List<Type> fileColumnTypes, List<String> fileColumnNames, MessageType messageType, Map<List<String>, Type> primitiveTypes, ParquetWriterOptions parquetWriterOptions, int[] fileInputColumnIndexes, CompressionCodec compressionCodec, String trinoVersion, TrinoFileSystem fileSystem) throws IOException {
        super(outputFile, rollbackAction, fileColumnTypes, fileColumnNames, messageType, primitiveTypes, parquetWriterOptions, fileInputColumnIndexes, compressionCodec, trinoVersion, Optional.empty(), Optional.empty());
        this.metricsConfig = Objects.requireNonNull(metricsConfig, "metricsConfig is null");
        this.inputFile = new ForwardingInputFile(fileSystem.newInputFile(outputFile.location()));
    }

    @Override
    public Metrics getMetrics() {
        return ParquetUtil.fileMetrics((InputFile)this.inputFile, (MetricsConfig)this.metricsConfig);
    }
}

