/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.SortingFileWriter;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.spi.Page;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.Metrics;

public class IcebergSortingFileWriter
implements IcebergFileWriter {
    private final IcebergFileWriter outputWriter;
    private final SortingFileWriter sortingFileWriter;

    public IcebergSortingFileWriter(TrinoFileSystem fileSystem, Location tempFilePrefix, IcebergFileWriter outputWriter, DataSize maxMemory, int maxOpenTempFiles, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders, PageSorter pageSorter, TypeOperators typeOperators) {
        this.outputWriter = Objects.requireNonNull(outputWriter, "outputWriter is null");
        this.sortingFileWriter = new SortingFileWriter(fileSystem, tempFilePrefix, (FileWriter)outputWriter, maxMemory, maxOpenTempFiles, types, sortFields, sortOrders, pageSorter, typeOperators, OrcFileWriterFactory::createOrcDataSink);
    }

    @Override
    public Metrics getMetrics() {
        return this.outputWriter.getMetrics();
    }

    public long getWrittenBytes() {
        return this.sortingFileWriter.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.sortingFileWriter.getMemoryUsage();
    }

    public void appendRows(Page dataPage) {
        this.sortingFileWriter.appendRows(dataPage);
    }

    public Closeable commit() {
        return this.sortingFileWriter.commit();
    }

    public void rollback() {
        this.sortingFileWriter.rollback();
    }

    public long getValidationCpuNanos() {
        return this.sortingFileWriter.getValidationCpuNanos();
    }

    public Optional<Runnable> getVerificationTask() {
        return this.sortingFileWriter.getVerificationTask();
    }
}

