/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.Table;

public class RefsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;

    public RefsTable(SchemaTableName tableName, Table icebergTable) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("name", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("type", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("max_reference_age_in_ms", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("min_snapshots_to_keep", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("max_snapshot_age_in_ms", (Type)BigintType.BIGINT)).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(RefsTable.buildPages(this.tableMetadata, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        icebergTable.refs().forEach((refName, ref) -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar((String)refName);
            pagesBuilder.appendVarchar(ref.isBranch() ? "BRANCH" : "TAG");
            pagesBuilder.appendBigint(ref.snapshotId());
            pagesBuilder.appendBigint(ref.maxRefAgeMs());
            pagesBuilder.appendInteger(ref.minSnapshotsToKeep());
            pagesBuilder.appendBigint(ref.maxSnapshotAgeMs());
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }
}

