/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.DecoratedHiveMetastoreModule;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreModule;
import io.trino.plugin.hive.metastore.thrift.TranslateHiveViews;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.MetastoreValidator;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.hms.HiveMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalogFactory;
import io.trino.plugin.iceberg.procedure.MigrateProcedure;
import io.trino.spi.procedure.Procedure;
import java.util.concurrent.TimeUnit;

public class IcebergHiveMetastoreCatalogModule
extends AbstractConfigurationAwareModule {
    public static final boolean HIDE_DELTA_LAKE_TABLES_IN_ICEBERG = false;

    protected void setup(Binder binder) {
        this.install((Module)new ThriftMetastoreModule());
        binder.bind(IcebergTableOperationsProvider.class).to(HiveMetastoreTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(TrinoCatalogFactory.class).to(TrinoHiveCatalogFactory.class).in(Scopes.SINGLETON);
        binder.bind(MetastoreValidator.class).asEagerSingleton();
        binder.bind(Key.get(Boolean.TYPE, TranslateHiveViews.class)).toInstance((Object)false);
        binder.bind(Key.get(Boolean.TYPE, HideDeltaLakeTables.class)).toInstance((Object)false);
        this.install((Module)new DecoratedHiveMetastoreModule(false));
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(CachingHiveMetastoreConfig.class, config -> config.setStatsCacheTtl(new Duration(0.0, TimeUnit.SECONDS)));
        Multibinder procedures = Multibinder.newSetBinder((Binder)binder, Procedure.class);
        procedures.addBinding().toProvider(MigrateProcedure.class).in(Scopes.SINGLETON);
    }
}

