/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogConfig;
import io.trino.plugin.iceberg.catalog.nessie.TrinoNessieCatalog;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import org.apache.iceberg.nessie.NessieIcebergClient;

public class TrinoNessieCatalogFactory
implements TrinoCatalogFactory {
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String warehouseLocation;
    private final NessieIcebergClient nessieClient;
    private final boolean isUniqueTableLocation;
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public TrinoNessieCatalogFactory(CatalogName catalogName, TypeManager typeManager, TrinoFileSystemFactory fileSystemFactory, IcebergTableOperationsProvider tableOperationsProvider, NessieIcebergClient nessieClient, IcebergNessieCatalogConfig icebergNessieCatalogConfig, IcebergConfig icebergConfig) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.nessieClient = Objects.requireNonNull(nessieClient, "nessieClient is null");
        this.warehouseLocation = icebergNessieCatalogConfig.getDefaultWarehouseDir();
        this.isUniqueTableLocation = icebergConfig.isUniqueTableLocation();
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        return new TrinoNessieCatalog(this.catalogName, this.typeManager, this.fileSystemFactory, this.tableOperationsProvider, this.nessieClient, this.warehouseLocation, this.isUniqueTableLocation);
    }
}

