/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;

public final class PageListBuilder {
    private final int channels;
    private final PageBuilder pageBuilder;
    private ImmutableList.Builder<Page> pages;
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.channels = types.size();
        this.pageBuilder = new PageBuilder(types);
        this.reset();
    }

    public void reset() {
        this.pages = ImmutableList.builder();
        this.pageBuilder.reset();
        this.channel = -1;
    }

    public List<Page> build() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"cannot be in row");
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"already in row");
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public void endRow() {
        Preconditions.checkArgument((this.channel == this.channels ? 1 : 0) != 0, (Object)"not at end of row");
        this.channel = -1;
    }

    public void appendNull() {
        this.nextColumn().appendNull();
    }

    public void appendInteger(int value) {
        IntegerType.INTEGER.writeLong(this.nextColumn(), (long)value);
    }

    public void appendInteger(Integer value) {
        if (this.checkNonNull(value)) {
            this.appendInteger((int)value);
        }
    }

    public void appendBigint(long value) {
        BigintType.BIGINT.writeLong(this.nextColumn(), value);
    }

    public void appendBigint(Long value) {
        if (this.checkNonNull(value)) {
            this.appendBigint((long)value);
        }
    }

    public void appendTimestampTzMillis(long millisUtc, TimeZoneKey timeZoneKey) {
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.writeLong(this.nextColumn(), DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
    }

    public void appendVarchar(String value) {
        VarcharType.VARCHAR.writeString(this.nextColumn(), value);
    }

    public void appendVarbinary(Slice value) {
        VarbinaryType.VARBINARY.writeSlice(this.nextColumn(), value);
    }

    public void appendIntegerArray(Iterable<Integer> values) {
        ArrayBlockBuilder column = (ArrayBlockBuilder)this.nextColumn();
        column.buildEntry(elementBuilder -> {
            for (Integer value : values) {
                IntegerType.INTEGER.writeLong(elementBuilder, (long)value.intValue());
            }
        });
    }

    public void appendBigintArray(Iterable<Long> values) {
        ArrayBlockBuilder column = (ArrayBlockBuilder)this.nextColumn();
        column.buildEntry(elementBuilder -> {
            for (Long value : values) {
                BigintType.BIGINT.writeLong(elementBuilder, value.longValue());
            }
        });
    }

    public void appendVarcharArray(Iterable<String> values) {
        ArrayBlockBuilder column = (ArrayBlockBuilder)this.nextColumn();
        column.buildEntry(elementBuilder -> {
            for (String value : values) {
                VarcharType.VARCHAR.writeString(elementBuilder, value);
            }
        });
    }

    public void appendVarcharVarcharMap(Map<String, String> values) {
        MapBlockBuilder column = (MapBlockBuilder)this.nextColumn();
        column.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            VarcharType.VARCHAR.writeString(keyBuilder, key);
            VarcharType.VARCHAR.writeString(valueBuilder, value);
        }));
    }

    public void appendIntegerBigintMap(Map<Integer, Long> values) {
        MapBlockBuilder column = (MapBlockBuilder)this.nextColumn();
        column.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
            BigintType.BIGINT.writeLong(valueBuilder, value.longValue());
        }));
    }

    public void appendIntegerVarcharMap(Map<Integer, String> values) {
        MapBlockBuilder column = (MapBlockBuilder)this.nextColumn();
        column.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
            VarcharType.VARCHAR.writeString(valueBuilder, value);
        }));
    }

    public BlockBuilder nextColumn() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }

    public static PageListBuilder forTable(ConnectorTableMetadata table) {
        return new PageListBuilder((List)table.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()));
    }

    private boolean checkNonNull(Object object) {
        if (object == null) {
            this.appendNull();
            return false;
        }
        return true;
    }
}

