/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.UpdateReturnState;

final class ConcurrentHeapThetaBuffer
extends HeapQuickSelectSketch {
    private final ConcurrentSharedThetaSketch shared;
    private boolean isExactMode;
    private final boolean propagateOrderedCompact;
    private final AtomicBoolean localPropagationInProgress;

    ConcurrentHeapThetaBuffer(int lgNomLongs, long seed, ConcurrentSharedThetaSketch shared, boolean propagateOrderedCompact, int maxNumLocalThreads) {
        super(ConcurrentHeapThetaBuffer.computeLogBufferSize(lgNomLongs, shared.getExactLimit(), maxNumLocalThreads), seed, 1.0f, ResizeFactor.X1, false);
        this.shared = shared;
        this.isExactMode = true;
        this.propagateOrderedCompact = propagateOrderedCompact;
        this.localPropagationInProgress = new AtomicBoolean(false);
    }

    private static int computeLogBufferSize(int lgNomLongs, long exactSize, int maxNumLocalBuffers) {
        return Math.min(lgNomLongs, (int)Math.log(Math.sqrt(exactSize) / (double)(2 * maxNumLocalBuffers)));
    }

    private boolean propagateToSharedSketch(long hash) {
        while (this.localPropagationInProgress.get()) {
        }
        this.localPropagationInProgress.set(true);
        boolean res = this.shared.propagate(this.localPropagationInProgress, null, hash);
        this.thetaLong_ = this.shared.getVolatileTheta();
        return res;
    }

    private void propagateToSharedSketch() {
        while (this.localPropagationInProgress.get()) {
        }
        CompactSketch compactSketch = this.compact(this.propagateOrderedCompact, null);
        this.localPropagationInProgress.set(true);
        this.shared.propagate(this.localPropagationInProgress, compactSketch, -1L);
        super.reset();
        this.thetaLong_ = this.shared.getVolatileTheta();
    }

    @Override
    public int getCompactBytes() {
        return this.shared.getCompactBytes();
    }

    @Override
    public int getCurrentBytes() {
        return this.shared.getCurrentBytes();
    }

    @Override
    public double getEstimate() {
        return this.shared.getEstimate();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return this.shared.getLowerBound(numStdDev);
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return this.shared.getUpperBound(numStdDev);
    }

    @Override
    public boolean hasMemory() {
        return this.shared.hasMemory();
    }

    @Override
    public boolean isDirect() {
        return this.shared.isDirect();
    }

    @Override
    public boolean isEmpty() {
        return this.shared.isEmpty();
    }

    @Override
    public boolean isEstimationMode() {
        return this.shared.isEstimationMode();
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException("Local theta buffer need not be serialized");
    }

    @Override
    public void reset() {
        super.reset();
        this.isExactMode = true;
        this.localPropagationInProgress.set(false);
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        if (this.isExactMode) {
            this.isExactMode = !this.shared.isEstimationMode();
        }
        HashOperations.checkHashCorruption(hash);
        if (this.getHashTableThreshold() == 0 || this.isExactMode) {
            if (HashOperations.continueCondition(this.getThetaLong(), hash)) {
                return UpdateReturnState.RejectedOverTheta;
            }
            if (this.propagateToSharedSketch(hash)) {
                return UpdateReturnState.ConcurrentPropagated;
            }
        }
        UpdateReturnState state = super.hashUpdate(hash);
        if (this.isOutOfSpace(this.getRetainedEntries(true) + 1)) {
            this.propagateToSharedSketch();
            return UpdateReturnState.ConcurrentPropagated;
        }
        if (state == UpdateReturnState.InsertedCountIncremented) {
            return UpdateReturnState.ConcurrentBufferInserted;
        }
        return state;
    }
}

