/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import com.google.common.base.Preconditions;
import io.trino.hadoop.ConfigurationInstantiator;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class ConfigurationUtils {
    private static final Configuration INITIAL_CONFIGURATION;

    private ConfigurationUtils() {
    }

    public static Configuration getInitialConfiguration() {
        return ConfigurationUtils.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        Configuration copy = ConfigurationInstantiator.newEmptyConfiguration();
        ConfigurationUtils.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Configuration readConfiguration(List<File> resourcePaths) {
        Configuration result = ConfigurationInstantiator.newEmptyConfiguration();
        for (File resourcePath : resourcePaths) {
            Preconditions.checkArgument((boolean)resourcePath.exists(), (String)"File does not exist: %s", (Object)resourcePath);
            Configuration resourceProperties = ConfigurationInstantiator.newEmptyConfiguration();
            resourceProperties.addResource(new Path(resourcePath.getPath()));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = ConfigurationInstantiator.newEmptyConfiguration();
        Configuration defaultConfiguration = ConfigurationInstantiator.newConfigurationWithDefaultResources();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

