/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.trino.parquet.ParquetReaderOptions;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"hive.parquet.fail-on-corrupted-statistics", "parquet.fail-on-corrupted-statistics", "parquet.optimized-reader.enabled", "parquet.optimized-nested-reader.enabled"})
public class ParquetReaderConfig {
    public static final String PARQUET_READER_MAX_SMALL_FILE_THRESHOLD = "15MB";
    private ParquetReaderOptions options = new ParquetReaderOptions();

    @Deprecated
    public boolean isIgnoreStatistics() {
        return this.options.isIgnoreStatistics();
    }

    @Deprecated
    @Config(value="parquet.ignore-statistics")
    @ConfigDescription(value="Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics")
    public ParquetReaderConfig setIgnoreStatistics(boolean ignoreStatistics) {
        this.options = this.options.withIgnoreStatistics(ignoreStatistics);
        return this;
    }

    @NotNull
    public DataSize getMaxReadBlockSize() {
        return this.options.getMaxReadBlockSize();
    }

    @Config(value="parquet.max-read-block-size")
    @LegacyConfig(value={"hive.parquet.max-read-block-size"})
    public ParquetReaderConfig setMaxReadBlockSize(DataSize maxReadBlockSize) {
        this.options = this.options.withMaxReadBlockSize(maxReadBlockSize);
        return this;
    }

    @Min(value=128L)
    @Max(value=65536L)
    public @Min(value=128L) @Max(value=65536L) int getMaxReadBlockRowCount() {
        return this.options.getMaxReadBlockRowCount();
    }

    @Config(value="parquet.max-read-block-row-count")
    @ConfigDescription(value="Maximum number of rows read in a batch")
    public ParquetReaderConfig setMaxReadBlockRowCount(int length) {
        this.options = this.options.withMaxReadBlockRowCount(length);
        return this;
    }

    @NotNull
    public DataSize getMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="parquet.max-merge-distance")
    public ParquetReaderConfig setMaxMergeDistance(DataSize distance) {
        this.options = this.options.withMaxMergeDistance(distance);
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    public @NotNull @MinDataSize(value="1MB") DataSize getMaxBufferSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="parquet.max-buffer-size")
    public ParquetReaderConfig setMaxBufferSize(DataSize size) {
        this.options = this.options.withMaxBufferSize(size);
        return this;
    }

    @Config(value="parquet.use-column-index")
    @ConfigDescription(value="Enable using Parquet column indexes")
    public ParquetReaderConfig setUseColumnIndex(boolean useColumnIndex) {
        this.options = this.options.withUseColumnIndex(useColumnIndex);
        return this;
    }

    public boolean isUseColumnIndex() {
        return this.options.isUseColumnIndex();
    }

    @Config(value="parquet.use-bloom-filter")
    @ConfigDescription(value="Use Parquet Bloom filters")
    public ParquetReaderConfig setUseBloomFilter(boolean useBloomFilter) {
        this.options = this.options.withBloomFilter(useBloomFilter);
        return this;
    }

    public boolean isUseBloomFilter() {
        return this.options.useBloomFilter();
    }

    @Config(value="parquet.small-file-threshold")
    @ConfigDescription(value="Size below which a parquet file will be read entirely")
    public ParquetReaderConfig setSmallFileThreshold(DataSize smallFileThreshold) {
        this.options = this.options.withSmallFileThreshold(smallFileThreshold);
        return this;
    }

    @NotNull
    @MaxDataSize(value="15MB")
    public @NotNull @MaxDataSize(value="15MB") DataSize getSmallFileThreshold() {
        return this.options.getSmallFileThreshold();
    }

    public ParquetReaderOptions toParquetReaderOptions() {
        return this.options;
    }
}

