/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryInputFile;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.rcfile.RcFileReader;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.rcfile.RcFilePageSource;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.joda.time.DateTimeZone;

public class RcFilePageSourceFactory
implements HivePageSourceFactory {
    private static final DataSize BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final TrinoFileSystemFactory fileSystemFactory;
    private final DateTimeZone timeZone;

    @Inject
    public RcFilePageSourceFactory(TrinoFileSystemFactory fileSystemFactory, HiveConfig hiveConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.timeZone = hiveConfig.getRcfileDateTimeZone();
    }

    public static Properties stripUnnecessaryProperties(Properties schema) {
        if ("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe".equals(HiveUtil.getDeserializerClassName(schema))) {
            Properties stripped = new Properties();
            stripped.put("serialization.lib", schema.getProperty("serialization.lib"));
            return stripped;
        }
        return schema;
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        Object data;
        TrinoInputFile inputFile;
        Optional<ReaderColumns> readerProjections;
        List projectedReaderColumns;
        BinaryColumnEncodingFactory columnEncodingFactory;
        block21: {
            String deserializerClassName = HiveUtil.getDeserializerClassName(schema);
            if (deserializerClassName.equals("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe")) {
                columnEncodingFactory = new BinaryColumnEncodingFactory(this.timeZone);
            } else if (deserializerClassName.equals("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")) {
                columnEncodingFactory = new TextColumnEncodingFactory(TextEncodingOptions.fromSchema((Map)Maps.fromProperties((Properties)schema)));
            } else {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            projectedReaderColumns = columns;
            readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            if (readerProjections.isPresent()) {
                projectedReaderColumns = (List)readerProjections.get().get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            }
            TrinoFileSystem trinoFileSystem = this.fileSystemFactory.create(session.getIdentity());
            inputFile = trinoFileSystem.newInputFile(path);
            try {
                length = Math.min(inputFile.length() - start, length);
                if (!inputFile.exists()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "File does not exist");
                }
                if (estimatedFileSize >= BUFFER_SIZE.toBytes()) break block21;
                try (TrinoInputStream inputStream = inputFile.newStream();){
                    data = inputStream.readAllBytes();
                    inputFile = new MemoryInputFile(path, Slices.wrappedBuffer((byte[])data));
                }
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
            }
        }
        if (length <= 0L) {
            return Optional.of(ReaderPageSource.noProjectionAdaptation((ConnectorPageSource)new EmptyPageSource()));
        }
        try {
            ImmutableMap.Builder readColumns = ImmutableMap.builder();
            data = projectedReaderColumns.iterator();
            while (data.hasNext()) {
                HiveColumnHandle column = (HiveColumnHandle)data.next();
                readColumns.put((Object)column.getBaseHiveColumnIndex(), (Object)column.getType());
            }
            RcFileReader rcFileReader = new RcFileReader(inputFile, (ColumnEncodingFactory)columnEncodingFactory, (Map)readColumns.buildOrThrow(), start, length);
            RcFilePageSource pageSource = new RcFilePageSource(rcFileReader, projectedReaderColumns);
            return Optional.of(new ReaderPageSource(pageSource, readerProjections));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Throwable e) {
            String message = HiveUtil.splitError(e, path, start, length);
            if (e instanceof FileCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, e);
        }
    }
}

