/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlStandardAccessControl
implements ConnectorAccessControl {
    public static final String ADMIN_ROLE_NAME = "admin";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private static final SchemaTableName ROLES = new SchemaTableName("information_schema", "roles");
    private final String catalogName;
    private final SqlStandardAccessControlMetastore metastore;

    @Inject
    public SqlStandardAccessControl(CatalogName catalogName, SqlStandardAccessControlMetastore metastore) {
        this.catalogName = catalogName.toString();
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName, Map<String, Object> properties) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schemaName, (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isDatabaseOwner(context, schemaName)) {
            AccessDeniedException.denyShowCreateSchema((String)schemaName);
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        if (!this.isDatabaseOwner(context, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denySetTableProperties((String)tableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyCommentView((String)viewName.toString());
        }
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.hasAnyTablePermission(context, tableName)) {
            AccessDeniedException.denyShowColumns((String)tableName.toString());
        }
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        if (!this.hasAnyTablePermission(context, tableName)) {
            return ImmutableSet.of();
        }
        return columns;
    }

    public Map<SchemaTableName, Set<String>> filterColumns(ConnectorSecurityContext context, Map<SchemaTableName, Set<String>> tableColumns) {
        return super.filterColumns(context, tableColumns);
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanAlterColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyAlterColumn((String)tableName.toString());
        }
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denySetTableAuthorization((String)tableName.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, false)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.INSERT, false)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.DELETE, false)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.UPDATE, false)) {
            AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumns);
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(context, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denySetViewAuthorization((String)viewName.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.checkCanSelectFromColumns(context, tableName, columnNames);
        if (!this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.SELECT, true)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)context.getIdentity());
        }
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        if (!this.isDatabaseOwner(context, materializedViewName.getSchemaName())) {
            AccessDeniedException.denyCreateMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        if (!this.checkTablePermission(context, materializedViewName, HivePrivilegeInfo.HivePrivilege.UPDATE, false)) {
            AccessDeniedException.denyRefreshMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        if (!this.isTableOwner(context, materializedViewName)) {
            AccessDeniedException.denyDropMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.isTableOwner(context, viewName)) {
            AccessDeniedException.denyRenameMaterializedView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        if (!this.isTableOwner(context, materializedViewName)) {
            AccessDeniedException.denySetMaterializedViewProperties((String)materializedViewName.toString());
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)this.catalogName, (String)propertyName);
        }
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support grants on schemas");
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deny on schemas");
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support revokes on schemas");
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        if (this.isTableOwner(context, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(context, privilege, tableName)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deny on tables");
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        if (this.isTableOwner(context, tableName)) {
            return;
        }
        if (!this.hasGrantOptionForPrivilege(context, privilege, tableName)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support WITH ADMIN statement");
        }
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyCreateRole((String)role);
        }
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyDropRole((String)role);
        }
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(context, roles)) {
            AccessDeniedException.denyGrantRoles(roles, grantees);
        }
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        if (grantor.isPresent()) {
            throw new AccessDeniedException("Hive Connector does not support GRANTED BY statement");
        }
        if (!this.hasAdminOptionForRoles(context, roles)) {
            AccessDeniedException.denyRevokeRoles(roles, grantees);
        }
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        if (!ThriftMetastoreUtil.isRoleApplicable(new HivePrincipal(PrincipalType.USER, context.getIdentity().getUser()), role, hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal))) {
            AccessDeniedException.denySetRole((String)role);
        }
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
        if (!this.isAdmin(context)) {
            AccessDeniedException.denyShowRoles();
        }
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
        if (!this.isTableOwner(context, tableName)) {
            AccessDeniedException.denyExecuteTableProcedure((String)tableName.toString(), (String)tableName.toString());
        }
    }

    public boolean canExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return !function.getSchemaName().equals("system") || this.isAdmin(context);
    }

    public boolean canCreateViewWithExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return this.canExecuteFunction(context, function);
    }

    public void checkCanShowFunctions(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaFunctionName> filterFunctions(ConnectorSecurityContext context, Set<SchemaFunctionName> functionNames) {
        return functionNames;
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        return ImmutableList.of();
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }

    private boolean isAdmin(ConnectorSecurityContext context) {
        return ThriftMetastoreUtil.isRoleEnabled(context.getIdentity(), hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal), ADMIN_ROLE_NAME);
    }

    private boolean isDatabaseOwner(ConnectorSecurityContext context, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        if (this.isAdmin(context)) {
            return true;
        }
        Optional<Database> databaseMetadata = this.metastore.getDatabase(context, databaseName);
        if (databaseMetadata.isEmpty()) {
            return false;
        }
        Database database = databaseMetadata.get();
        ConnectorIdentity identity = context.getIdentity();
        if (database.getOwnerName().isPresent()) {
            if (database.getOwnerType().orElse(null) == PrincipalType.USER && identity.getUser().equals(database.getOwnerName().get())) {
                return true;
            }
            if (database.getOwnerType().orElse(null) == PrincipalType.ROLE && ThriftMetastoreUtil.isRoleEnabled(identity, hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal), database.getOwnerName().get())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTableOwner(ConnectorSecurityContext context, SchemaTableName tableName) {
        return this.checkTablePermission(context, tableName, HivePrivilegeInfo.HivePrivilege.OWNERSHIP, false);
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, HivePrivilegeInfo.HivePrivilege requiredPrivilege, boolean grantOptionRequired) {
        if (this.isAdmin(context)) {
            return true;
        }
        if (tableName.equals((Object)ROLES)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        Set allowedPrincipals = (Set)this.metastore.listTablePrivileges(context, tableName.getSchemaName(), tableName.getTableName(), Optional.empty()).stream().filter(privilegeInfo -> privilegeInfo.getHivePrivilege() == requiredPrivilege).filter(privilegeInfo -> !grantOptionRequired || privilegeInfo.isGrantOption()).map(HivePrivilegeInfo::getGrantee).collect(ImmutableSet.toImmutableSet());
        return ThriftMetastoreUtil.listEnabledPrincipals(context.getIdentity(), hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal)).anyMatch(allowedPrincipals::contains);
    }

    private boolean hasGrantOptionForPrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName) {
        if (this.isAdmin(context)) {
            return true;
        }
        if (privilege == Privilege.CREATE) {
            return false;
        }
        return this.listApplicableTablePrivileges(context, tableName.getSchemaName(), tableName.getTableName(), context.getIdentity()).anyMatch(privilegeInfo -> privilegeInfo.getHivePrivilege() == HivePrivilegeInfo.toHivePrivilege(privilege) && privilegeInfo.isGrantOption());
    }

    private Stream<HivePrivilegeInfo> listApplicableTablePrivileges(ConnectorSecurityContext context, String databaseName, String tableName, ConnectorIdentity identity) {
        String user = identity.getUser();
        HivePrincipal userPrincipal = new HivePrincipal(PrincipalType.USER, user);
        Stream<HivePrincipal> principals = Stream.concat(Stream.of(userPrincipal), ThriftMetastoreUtil.listApplicableRoles(userPrincipal, hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal)).map(role -> new HivePrincipal(PrincipalType.ROLE, role.getRoleName())));
        return this.listTablePrivileges(context, databaseName, tableName, principals);
    }

    private Stream<HivePrivilegeInfo> listTablePrivileges(ConnectorSecurityContext context, String databaseName, String tableName, Stream<HivePrincipal> principals) {
        return principals.flatMap(principal -> this.metastore.listTablePrivileges(context, databaseName, tableName, Optional.of(principal)).stream());
    }

    private boolean hasAdminOptionForRoles(ConnectorSecurityContext context, Set<String> roles) {
        if (this.isAdmin(context)) {
            return true;
        }
        Set rolesWithGrantOption = ThriftMetastoreUtil.listApplicableRoles(new HivePrincipal(PrincipalType.USER, context.getIdentity().getUser()), hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal)).filter(RoleGrant::isGrantable).map(RoleGrant::getRoleName).collect(Collectors.toSet());
        return rolesWithGrantOption.containsAll(roles);
    }

    private boolean hasAnyTablePermission(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (this.isAdmin(context)) {
            return true;
        }
        if (tableName.equals((Object)ROLES)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        Set allowedPrincipals = (Set)this.metastore.listTablePrivileges(context, tableName.getSchemaName(), tableName.getTableName(), Optional.empty()).stream().map(HivePrivilegeInfo::getGrantee).collect(ImmutableSet.toImmutableSet());
        return ThriftMetastoreUtil.listEnabledPrincipals(context.getIdentity(), hivePrincipal -> this.metastore.listRoleGrants(context, (HivePrincipal)hivePrincipal)).anyMatch(allowedPrincipals::contains);
    }
}

