/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class Int96TimestampValueWriter
extends PrimitiveValueWriter {
    private final TimestampType timestampType;
    private final DateTimeZone parquetTimeZone;

    public Int96TimestampValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType, DateTimeZone parquetTimeZone) {
        super(parquetType, valuesWriter);
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type instanceof TimestampType && ((TimestampType)type).getPrecision() <= 9 ? 1 : 0) != 0, (String)"type %s is not a TimestampType with precision <= 9", (Object)type);
        this.timestampType = (TimestampType)type;
        Preconditions.checkArgument((boolean)parquetType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96), (String)"parquetType %s is not INT96", (Object)parquetType);
        this.parquetTimeZone = Objects.requireNonNull(parquetTimeZone, "parquetTimeZone is null");
    }

    @Override
    public void write(Block block) {
        int positionCount = block.getPositionCount();
        long[] localEpochMillis = new long[positionCount];
        int[] nanosOfMillis = new int[positionCount];
        int nonNullsCount = 0;
        if (this.timestampType.isShort()) {
            for (position = 0; position < positionCount; ++position) {
                if (block.isNull(position)) continue;
                long epochMicros = this.timestampType.getLong(block, position);
                localEpochMillis[nonNullsCount] = Math.floorDiv(epochMicros, 1000);
                nanosOfMillis[nonNullsCount] = Math.floorMod(epochMicros, 1000) * 1000;
                ++nonNullsCount;
            }
        } else {
            for (position = 0; position < positionCount; ++position) {
                if (block.isNull(position)) continue;
                LongTimestamp timestamp = (LongTimestamp)this.timestampType.getObject(block, position);
                long epochMicros = timestamp.getEpochMicros();
                int nanosOfMicro = timestamp.getPicosOfMicro() / 1000;
                localEpochMillis[nonNullsCount] = Math.floorDiv(epochMicros, 1000);
                nanosOfMillis[nonNullsCount] = Math.floorMod(epochMicros, 1000) * 1000 + nanosOfMicro;
                ++nonNullsCount;
            }
        }
        for (int i = 0; i < nonNullsCount; ++i) {
            long epochMillis = this.parquetTimeZone.convertLocalToUTC(localEpochMillis[i], false);
            long epochDay = Math.floorDiv(epochMillis, 86400000);
            int julianDay = 2440588 + Math.toIntExact(epochDay);
            long nanosOfEpochDay = (long)nanosOfMillis[i] + (long)Math.floorMod(epochMillis, 86400000) * 1000000L;
            Binary binary = this.toBinary(julianDay, nanosOfEpochDay);
            this.getValueWriter().writeBytes(binary);
            this.getStatistics().updateStats(binary);
        }
    }

    private Binary toBinary(int julianDay, long nanosOfEpochDay) {
        byte[] buffer = new byte[12];
        Int96TimestampValueWriter.longToBytes(buffer, nanosOfEpochDay);
        Int96TimestampValueWriter.intToBytes(buffer, julianDay);
        return Binary.fromConstantByteArray((byte[])buffer);
    }

    private static void intToBytes(byte[] outBuffer, int value) {
        outBuffer[11] = (byte)(value >>> 24);
        outBuffer[10] = (byte)(value >>> 16);
        outBuffer[9] = (byte)(value >>> 8);
        outBuffer[8] = (byte)value;
    }

    private static void longToBytes(byte[] outBuffer, long value) {
        outBuffer[7] = (byte)(value >>> 56);
        outBuffer[6] = (byte)(value >>> 48);
        outBuffer[5] = (byte)(value >>> 40);
        outBuffer[4] = (byte)(value >>> 32);
        outBuffer[3] = (byte)(value >>> 24);
        outBuffer[2] = (byte)(value >>> 16);
        outBuffer[1] = (byte)(value >>> 8);
        outBuffer[0] = (byte)value;
    }
}

