/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Identifier;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.QualifiedName;
import com.linkedin.coral.$internal.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RenameColumn
extends Statement {
    private final QualifiedName table;
    private final Identifier source;
    private final Identifier target;
    private final boolean tableExists;
    private final boolean columnExists;

    public RenameColumn(QualifiedName table, Identifier source, Identifier target, boolean tableExists, boolean columnExists) {
        this(Optional.empty(), table, source, target, tableExists, columnExists);
    }

    public RenameColumn(NodeLocation location, QualifiedName table, Identifier source, Identifier target, boolean tableExists, boolean columnExists) {
        this(Optional.of(location), table, source, target, tableExists, columnExists);
    }

    private RenameColumn(Optional<NodeLocation> location, QualifiedName table, Identifier source, Identifier target, boolean tableExists, boolean columnExists) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.tableExists = tableExists;
        this.columnExists = columnExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnExists() {
        return this.columnExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumn that = (RenameColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.source, this.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).add("source", this.source).add("target", this.target).toString();
    }
}

