/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.openjdk.jol.layouters;

import com.linkedin.coral.$internal.org.openjdk.jol.datamodel.DataModel;
import com.linkedin.coral.$internal.org.openjdk.jol.info.ClassData;
import com.linkedin.coral.$internal.org.openjdk.jol.info.ClassLayout;
import com.linkedin.coral.$internal.org.openjdk.jol.info.FieldData;
import com.linkedin.coral.$internal.org.openjdk.jol.info.FieldLayout;
import com.linkedin.coral.$internal.org.openjdk.jol.layouters.Layouter;
import com.linkedin.coral.$internal.org.openjdk.jol.util.VMSupport;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class HotSpotLayouter
implements Layouter {
    private final DataModel model;
    private final boolean takeHierarchyGaps;
    private final boolean takeSuperGaps;
    private final boolean autoAlign;

    public HotSpotLayouter(DataModel model) {
        this(model, false, false, false);
    }

    public HotSpotLayouter(DataModel model, boolean takeHierarchyGaps, boolean takeSuperGaps, boolean autoAlign) {
        this.model = model;
        this.takeHierarchyGaps = takeHierarchyGaps;
        this.takeSuperGaps = takeSuperGaps;
        this.autoAlign = autoAlign;
    }

    @Override
    public ClassLayout layout(ClassData cd2) {
        int instanceSize;
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (cd2.isArray()) {
            int base = this.model.headerSize() + this.model.sizeOf("int");
            int scale = this.model.sizeOf(cd2.arrayComponentType());
            int instanceSize2 = base + cd2.arrayLength() * scale;
            instanceSize2 = VMSupport.align(instanceSize2, this.autoAlign ? Math.max(4, scale) : 8);
            base = VMSupport.align(base, Math.max(4, scale));
            result.add(new FieldLayout(FieldData.create(cd2.arrayClass(), "length", "int"), this.model.headerSize(), this.model.sizeOf("int")));
            result.add(new FieldLayout(FieldData.create(cd2.arrayClass(), "<elements>", cd2.arrayComponentType()), base, scale * cd2.arrayLength()));
            return new ClassLayout(cd2, result, this.model.headerSize(), instanceSize2, false);
        }
        List<String> hierarchy = cd2.classHierarchy();
        BitSet claimed = new BitSet();
        claimed.set(0, this.model.headerSize());
        for (String k : hierarchy) {
            Collection<FieldData> fields = cd2.fieldsFor(k);
            TreeSet<FieldLayout> current = new TreeSet<FieldLayout>();
            for (int size : new int[]{8, 4, 2, 1}) {
                block2: for (FieldData f : fields) {
                    int fSize = this.model.sizeOf(f.typeClass());
                    if (fSize != size) continue;
                    for (int t = 0; t < Integer.MAX_VALUE; ++t) {
                        if (!claimed.get(t * size, (t + 1) * size).isEmpty()) continue;
                        claimed.set(t * size, (t + 1) * size);
                        current.add(new FieldLayout(f, t * size, size));
                        continue block2;
                    }
                }
            }
            result.addAll(current);
            if (this.takeSuperGaps) continue;
            if (this.takeHierarchyGaps) {
                int lastSet = claimed.length() - 1;
                claimed.set(0, lastSet);
                continue;
            }
            int lastSet = claimed.length() - 1;
            claimed.set(0, VMSupport.align(lastSet, 4));
        }
        if (this.autoAlign) {
            int a = 4;
            for (FieldLayout f : result) {
                a = Math.max(a, this.model.sizeOf(f.typeClass()));
            }
            instanceSize = VMSupport.align(claimed.length(), a);
        } else {
            instanceSize = VMSupport.align(claimed.length());
        }
        return new ClassLayout(cd2, result, this.model.headerSize(), instanceSize, true);
    }

    public String toString() {
        return "VM Layout Simulation (" + this.model + (this.takeHierarchyGaps ? ", hierarchy gaps" : "") + (this.takeSuperGaps ? ", super gaps" : "") + (this.autoAlign ? ", autoalign" : "") + ")";
    }
}

