/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.common.FuzzyUnionSqlRewriter;
import com.linkedin.coral.trino.trino2rel.TrinoToRelConverter;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Util;

public class TrinoViewExpander
implements RelOptTable.ViewExpander {
    private final TrinoToRelConverter trinoToRelConverter;

    public TrinoViewExpander(@Nonnull TrinoToRelConverter trinoToRelConverter) {
        this.trinoToRelConverter = trinoToRelConverter;
    }

    @Override
    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        Preconditions.checkNotNull(viewPath);
        Preconditions.checkState((!viewPath.isEmpty() ? 1 : 0) != 0);
        String dbName = Util.last(schemaPath);
        String tableName = viewPath.get(0);
        SqlNode sqlNode = this.trinoToRelConverter.processView(dbName, tableName).accept(new FuzzyUnionSqlRewriter(tableName, this.trinoToRelConverter));
        return this.trinoToRelConverter.getSqlToRelConverter().convertQuery(sqlNode, true, true);
    }
}

