/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentMetadata;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="MergeKeyBehavior", generator="Immutables")
@Immutable
public final class ImmutableMergeKeyBehavior
implements MergeKeyBehavior {
    private final ContentKey key;
    private final MergeBehavior mergeBehavior;
    private final Content expectedTargetContent;
    private final Content resolvedContent;
    private final Documentation expectedTargetDocumentation;
    private final Documentation resolvedDocumentation;
    private final List<ContentMetadata> metadata;

    private ImmutableMergeKeyBehavior(ContentKey key, MergeBehavior mergeBehavior, Content expectedTargetContent, Content resolvedContent, Documentation expectedTargetDocumentation, Documentation resolvedDocumentation, List<ContentMetadata> metadata) {
        this.key = key;
        this.mergeBehavior = mergeBehavior;
        this.expectedTargetContent = expectedTargetContent;
        this.resolvedContent = resolvedContent;
        this.expectedTargetDocumentation = expectedTargetDocumentation;
        this.resolvedDocumentation = resolvedDocumentation;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="mergeBehavior")
    public MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    @Override
    @JsonProperty(value="expectedTargetContent")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    public Content getExpectedTargetContent() {
        return this.expectedTargetContent;
    }

    @Override
    @JsonProperty(value="resolvedContent")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    public Content getResolvedContent() {
        return this.resolvedContent;
    }

    @Override
    @JsonProperty(value="expectedTargetDocumentation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    public Documentation getExpectedTargetDocumentation() {
        return this.expectedTargetDocumentation;
    }

    @Override
    @JsonProperty(value="resolvedDocumentation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    public Documentation getResolvedDocumentation() {
        return this.resolvedDocumentation;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.V2.class})
    public List<ContentMetadata> getMetadata() {
        return this.metadata;
    }

    public final ImmutableMergeKeyBehavior withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableMergeKeyBehavior(newValue, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withMergeBehavior(MergeBehavior value) {
        MergeBehavior newValue = Objects.requireNonNull(value, "mergeBehavior");
        if (this.mergeBehavior == newValue) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, newValue, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withExpectedTargetContent(Content value) {
        if (this.expectedTargetContent == value) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, value, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withResolvedContent(Content value) {
        if (this.resolvedContent == value) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, value, this.expectedTargetDocumentation, this.resolvedDocumentation, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withExpectedTargetDocumentation(Documentation value) {
        if (this.expectedTargetDocumentation == value) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, value, this.resolvedDocumentation, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withResolvedDocumentation(Documentation value) {
        if (this.resolvedDocumentation == value) {
            return this;
        }
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, value, this.metadata);
    }

    public final ImmutableMergeKeyBehavior withMetadata(ContentMetadata ... elements) {
        List<ContentMetadata> newValue = ImmutableMergeKeyBehavior.createUnmodifiableList(false, ImmutableMergeKeyBehavior.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, newValue);
    }

    public final ImmutableMergeKeyBehavior withMetadata(Iterable<? extends ContentMetadata> elements) {
        if (this.metadata == elements) {
            return this;
        }
        List<ContentMetadata> newValue = ImmutableMergeKeyBehavior.createUnmodifiableList(false, ImmutableMergeKeyBehavior.createSafeList(elements, true, false));
        return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeKeyBehavior && this.equalTo(0, (ImmutableMergeKeyBehavior)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeKeyBehavior another) {
        return this.key.equals(another.key) && this.mergeBehavior.equals((Object)another.mergeBehavior) && Objects.equals(this.expectedTargetContent, another.expectedTargetContent) && Objects.equals(this.resolvedContent, another.resolvedContent) && Objects.equals(this.expectedTargetDocumentation, another.expectedTargetDocumentation) && Objects.equals(this.resolvedDocumentation, another.resolvedDocumentation) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.mergeBehavior.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedTargetContent);
        h += (h << 5) + Objects.hashCode(this.resolvedContent);
        h += (h << 5) + Objects.hashCode(this.expectedTargetDocumentation);
        h += (h << 5) + Objects.hashCode(this.resolvedDocumentation);
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        return "MergeKeyBehavior{key=" + this.key + ", mergeBehavior=" + (Object)((Object)this.mergeBehavior) + ", expectedTargetContent=" + this.expectedTargetContent + ", resolvedContent=" + this.resolvedContent + ", expectedTargetDocumentation=" + this.expectedTargetDocumentation + ", resolvedDocumentation=" + this.resolvedDocumentation + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeKeyBehavior fromJson(Json json) {
        Builder builder = ImmutableMergeKeyBehavior.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.mergeBehavior != null) {
            builder.mergeBehavior(json.mergeBehavior);
        }
        if (json.expectedTargetContent != null) {
            builder.expectedTargetContent(json.expectedTargetContent);
        }
        if (json.resolvedContent != null) {
            builder.resolvedContent(json.resolvedContent);
        }
        if (json.expectedTargetDocumentation != null) {
            builder.expectedTargetDocumentation(json.expectedTargetDocumentation);
        }
        if (json.resolvedDocumentation != null) {
            builder.resolvedDocumentation(json.resolvedDocumentation);
        }
        if (json.metadata != null) {
            builder.addAllMetadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableMergeKeyBehavior copyOf(MergeKeyBehavior instance) {
        if (instance instanceof ImmutableMergeKeyBehavior) {
            return (ImmutableMergeKeyBehavior)instance;
        }
        return ImmutableMergeKeyBehavior.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="MergeKeyBehavior", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_MERGE_BEHAVIOR = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentKey key;
        @Nullable
        private MergeBehavior mergeBehavior;
        @Nullable
        private Content expectedTargetContent;
        @Nullable
        private Content resolvedContent;
        @Nullable
        private Documentation expectedTargetDocumentation;
        @Nullable
        private Documentation resolvedDocumentation;
        private List<ContentMetadata> metadata = new ArrayList<ContentMetadata>();

        private Builder() {
        }

        public final Builder from(MergeKeyBehavior instance) {
            Documentation resolvedDocumentationValue;
            Documentation expectedTargetDocumentationValue;
            Content resolvedContentValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.mergeBehavior(instance.getMergeBehavior());
            Content expectedTargetContentValue = instance.getExpectedTargetContent();
            if (expectedTargetContentValue != null) {
                this.expectedTargetContent(expectedTargetContentValue);
            }
            if ((resolvedContentValue = instance.getResolvedContent()) != null) {
                this.resolvedContent(resolvedContentValue);
            }
            if ((expectedTargetDocumentationValue = instance.getExpectedTargetDocumentation()) != null) {
                this.expectedTargetDocumentation(expectedTargetDocumentationValue);
            }
            if ((resolvedDocumentationValue = instance.getResolvedDocumentation()) != null) {
                this.resolvedDocumentation(resolvedDocumentationValue);
            }
            this.addAllMetadata(instance.getMetadata());
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mergeBehavior")
        public final Builder mergeBehavior(MergeBehavior mergeBehavior) {
            this.mergeBehavior = Objects.requireNonNull(mergeBehavior, "mergeBehavior");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expectedTargetContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public final Builder expectedTargetContent(Content expectedTargetContent) {
            this.expectedTargetContent = expectedTargetContent;
            return this;
        }

        @JsonProperty(value="resolvedContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public final Builder resolvedContent(Content resolvedContent) {
            this.resolvedContent = resolvedContent;
            return this;
        }

        @JsonProperty(value="expectedTargetDocumentation")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public final Builder expectedTargetDocumentation(Documentation expectedTargetDocumentation) {
            this.expectedTargetDocumentation = expectedTargetDocumentation;
            return this;
        }

        @JsonProperty(value="resolvedDocumentation")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public final Builder resolvedDocumentation(Documentation resolvedDocumentation) {
            this.resolvedDocumentation = resolvedDocumentation;
            return this;
        }

        public final Builder addMetadata(ContentMetadata element) {
            this.metadata.add(Objects.requireNonNull(element, "metadata element"));
            return this;
        }

        public final Builder addMetadata(ContentMetadata ... elements) {
            for (ContentMetadata element : elements) {
                this.metadata.add(Objects.requireNonNull(element, "metadata element"));
            }
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonView(value={Views.V2.class})
        public final Builder metadata(Iterable<? extends ContentMetadata> elements) {
            this.metadata.clear();
            return this.addAllMetadata(elements);
        }

        public final Builder addAllMetadata(Iterable<? extends ContentMetadata> elements) {
            for (ContentMetadata contentMetadata : elements) {
                this.metadata.add(Objects.requireNonNull(contentMetadata, "metadata element"));
            }
            return this;
        }

        public ImmutableMergeKeyBehavior build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeKeyBehavior(this.key, this.mergeBehavior, this.expectedTargetContent, this.resolvedContent, this.expectedTargetDocumentation, this.resolvedDocumentation, ImmutableMergeKeyBehavior.createUnmodifiableList(true, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mergeBehavior");
            }
            return "Cannot build MergeKeyBehavior, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeKeyBehavior", generator="Immutables")
    static final class Json
    implements MergeKeyBehavior {
        @Nullable
        ContentKey key;
        @Nullable
        MergeBehavior mergeBehavior;
        @Nullable
        Content expectedTargetContent;
        @Nullable
        Content resolvedContent;
        @Nullable
        Documentation expectedTargetDocumentation;
        @Nullable
        Documentation resolvedDocumentation;
        @Nullable
        List<ContentMetadata> metadata = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="mergeBehavior")
        public void setMergeBehavior(MergeBehavior mergeBehavior) {
            this.mergeBehavior = mergeBehavior;
        }

        @JsonProperty(value="expectedTargetContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public void setExpectedTargetContent(Content expectedTargetContent) {
            this.expectedTargetContent = expectedTargetContent;
        }

        @JsonProperty(value="resolvedContent")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public void setResolvedContent(Content resolvedContent) {
            this.resolvedContent = resolvedContent;
        }

        @JsonProperty(value="expectedTargetDocumentation")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public void setExpectedTargetDocumentation(Documentation expectedTargetDocumentation) {
            this.expectedTargetDocumentation = expectedTargetDocumentation;
        }

        @JsonProperty(value="resolvedDocumentation")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public void setResolvedDocumentation(Documentation resolvedDocumentation) {
            this.resolvedDocumentation = resolvedDocumentation;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonView(value={Views.V2.class})
        public void setMetadata(List<ContentMetadata> metadata) {
            this.metadata = metadata;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeBehavior getMergeBehavior() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getExpectedTargetContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getResolvedContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Documentation getExpectedTargetDocumentation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Documentation getResolvedDocumentation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ContentMetadata> getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

