/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FilesTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final TypeManager typeManager;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public FilesTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("content", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("file_path", (io.trino.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("file_format", (io.trino.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("record_count", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("file_size_in_bytes", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("column_sizes", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("null_value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("nan_value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("lower_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("upper_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("key_metadata", (io.trino.spi.type.Type)VarbinaryType.VARBINARY)).add((Object)new ColumnMetadata("split_offsets", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)BigintType.BIGINT))).add((Object)new ColumnMetadata("equality_ids", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        List types = (List)this.tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        if (this.snapshotId.isEmpty()) {
            return InMemoryRecordSet.builder((Collection)types).build().cursor();
        }
        Map<Integer, Type> idToTypeMapping = FilesTable.getIcebergIdToTypeMapping(this.icebergTable.schema());
        TableScan tableScan = (TableScan)this.icebergTable.newScan().useSnapshot(this.snapshotId.get().longValue()).includeColumnStats();
        PlanFilesIterable planFilesIterable = new PlanFilesIterable((CloseableIterable<FileScanTask>)tableScan.planFiles(), idToTypeMapping, types, this.typeManager);
        return planFilesIterable.cursor();
    }

    private static Map<Integer, Type> getIcebergIdToTypeMapping(Schema schema) {
        ImmutableMap.Builder icebergIdToTypeMapping = ImmutableMap.builder();
        for (Types.NestedField field : schema.columns()) {
            FilesTable.populateIcebergIdToTypeMapping(field, (ImmutableMap.Builder<Integer, Type>)icebergIdToTypeMapping);
        }
        return icebergIdToTypeMapping.buildOrThrow();
    }

    private static void populateIcebergIdToTypeMapping(Types.NestedField field, ImmutableMap.Builder<Integer, Type> icebergIdToTypeMapping) {
        Type type = field.type();
        icebergIdToTypeMapping.put((Object)field.fieldId(), (Object)type);
        if (type instanceof Type.NestedType) {
            type.asNestedType().fields().forEach(child -> FilesTable.populateIcebergIdToTypeMapping(child, icebergIdToTypeMapping));
        }
    }

    private static class PlanFilesIterable
    extends CloseableGroup
    implements Iterable<List<Object>> {
        private final CloseableIterable<FileScanTask> planFiles;
        private final Map<Integer, Type> idToTypeMapping;
        private final List<io.trino.spi.type.Type> types;
        private boolean closed;
        private final MapType integerToBigintMapType;
        private final MapType integerToVarcharMapType;

        public PlanFilesIterable(CloseableIterable<FileScanTask> planFiles, Map<Integer, Type> idToTypeMapping, List<io.trino.spi.type.Type> types, TypeManager typeManager) {
            this.planFiles = Objects.requireNonNull(planFiles, "planFiles is null");
            this.idToTypeMapping = ImmutableMap.copyOf(Objects.requireNonNull(idToTypeMapping, "idToTypeMapping is null"));
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.integerToBigintMapType = new MapType((io.trino.spi.type.Type)IntegerType.INTEGER, (io.trino.spi.type.Type)BigintType.BIGINT, typeManager.getTypeOperators());
            this.integerToVarcharMapType = new MapType((io.trino.spi.type.Type)IntegerType.INTEGER, (io.trino.spi.type.Type)VarcharType.VARCHAR, typeManager.getTypeOperators());
            this.addCloseable((Closeable)planFiles);
        }

        public RecordCursor cursor() {
            CloseableIterator<List<Object>> iterator = this.iterator();
            return new InMemoryRecordSet.InMemoryRecordCursor(this.types, (Iterator)iterator, (CloseableIterator)iterator){
                final /* synthetic */ CloseableIterator val$iterator;
                {
                    this.val$iterator = closeableIterator;
                    super(types, records);
                }

                public void close() {
                    try (CloseableIterator closeableIterator = this.val$iterator;){
                        super.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to close cursor", e);
                    }
                }
            };
        }

        @Override
        public CloseableIterator<List<Object>> iterator() {
            final CloseableIterator planFilesIterator = this.planFiles.iterator();
            this.addCloseable((Closeable)planFilesIterator);
            return new CloseableIterator<List<Object>>(){

                public boolean hasNext() {
                    return !closed && planFilesIterator.hasNext();
                }

                public List<Object> next() {
                    return this.getRecord((DataFile)((FileScanTask)planFilesIterator.next()).file());
                }

                public void close() throws IOException {
                    PlanFilesIterable.super.close();
                    closed = true;
                }
            };
        }

        private List<Object> getRecord(DataFile dataFile) {
            ArrayList<Object> columns = new ArrayList<Object>();
            columns.add(dataFile.content().id());
            columns.add(dataFile.path().toString());
            columns.add(dataFile.format().name());
            columns.add(dataFile.recordCount());
            columns.add(dataFile.fileSizeInBytes());
            columns.add(this.getIntegerBigintSqlMap(dataFile.columnSizes()));
            columns.add(this.getIntegerBigintSqlMap(dataFile.valueCounts()));
            columns.add(this.getIntegerBigintSqlMap(dataFile.nullValueCounts()));
            columns.add(this.getIntegerBigintSqlMap(dataFile.nanValueCounts()));
            columns.add(this.getIntegerVarcharSqlMap(dataFile.lowerBounds()));
            columns.add(this.getIntegerVarcharSqlMap(dataFile.upperBounds()));
            columns.add(PlanFilesIterable.toVarbinarySlice(dataFile.keyMetadata()));
            columns.add(PlanFilesIterable.toBigintArrayBlock(dataFile.splitOffsets()));
            columns.add(PlanFilesIterable.toIntegerArrayBlock(dataFile.equalityFieldIds()));
            Preconditions.checkArgument((columns.size() == this.types.size() ? 1 : 0) != 0, (String)"Expected %s types in row, but got %s values", (int)this.types.size(), (int)columns.size());
            return columns;
        }

        private SqlMap getIntegerBigintSqlMap(Map<Integer, Long> value) {
            if (value == null) {
                return null;
            }
            return this.toIntegerBigintSqlMap(value);
        }

        private SqlMap getIntegerVarcharSqlMap(Map<Integer, ByteBuffer> value) {
            if (value == null) {
                return null;
            }
            return this.toIntegerVarcharSqlMap((Map)value.entrySet().stream().filter(entry -> this.idToTypeMapping.containsKey(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity().toHumanString(this.idToTypeMapping.get(entry.getKey()), Conversions.fromByteBuffer((Type)this.idToTypeMapping.get(entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
        }

        private SqlMap toIntegerBigintSqlMap(Map<Integer, Long> values) {
            return MapValueBuilder.buildMapValue((MapType)this.integerToBigintMapType, (int)values.size(), (keyBuilder, valueBuilder) -> values.forEach((? super K key, ? super V value) -> {
                IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
                BigintType.BIGINT.writeLong(valueBuilder, value.longValue());
            }));
        }

        private SqlMap toIntegerVarcharSqlMap(Map<Integer, String> values) {
            return MapValueBuilder.buildMapValue((MapType)this.integerToVarcharMapType, (int)values.size(), (keyBuilder, valueBuilder) -> values.forEach((? super K key, ? super V value) -> {
                IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
                VarcharType.VARCHAR.writeString(valueBuilder, value);
            }));
        }

        @Nullable
        private static Block toIntegerArrayBlock(List<Integer> values) {
            if (values == null) {
                return null;
            }
            BlockBuilder builder = IntegerType.INTEGER.createBlockBuilder(null, values.size());
            values.forEach(value -> IntegerType.INTEGER.writeLong(builder, (long)value.intValue()));
            return builder.build();
        }

        @Nullable
        private static Block toBigintArrayBlock(List<Long> values) {
            if (values == null) {
                return null;
            }
            BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, values.size());
            values.forEach(value -> BigintType.BIGINT.writeLong(builder, value.longValue()));
            return builder.build();
        }

        @Nullable
        private static Slice toVarbinarySlice(ByteBuffer value) {
            if (value == null) {
                return null;
            }
            return Slices.wrappedHeapBuffer((ByteBuffer)value);
        }
    }
}

