/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class IcebergSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IcebergSplit.class);
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final long fileRecordCount;
    private final IcebergFileFormat fileFormat;
    private final String partitionSpecJson;
    private final String partitionDataJson;
    private final List<DeleteFile> deletes;
    private final SplitWeight splitWeight;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileRecordCount") long fileRecordCount, @JsonProperty(value="fileFormat") IcebergFileFormat fileFormat, @JsonProperty(value="partitionSpecJson") String partitionSpecJson, @JsonProperty(value="partitionDataJson") String partitionDataJson, @JsonProperty(value="deletes") List<DeleteFile> deletes, @JsonProperty(value="splitWeight") SplitWeight splitWeight) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileRecordCount = fileRecordCount;
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.partitionSpecJson = Objects.requireNonNull(partitionSpecJson, "partitionSpecJson is null");
        this.partitionDataJson = Objects.requireNonNull(partitionDataJson, "partitionDataJson is null");
        this.deletes = ImmutableList.copyOf((Collection)Objects.requireNonNull(deletes, "deletes is null"));
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonIgnore
    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public long getFileRecordCount() {
        return this.fileRecordCount;
    }

    @JsonProperty
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public String getPartitionSpecJson() {
        return this.partitionSpecJson;
    }

    @JsonProperty
    public String getPartitionDataJson() {
        return this.partitionDataJson;
    }

    @JsonProperty
    public List<DeleteFile> getDeletes() {
        return this.deletes;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf((String)this.partitionSpecJson) + SizeOf.estimatedSizeOf((String)this.partitionDataJson) + SizeOf.estimatedSizeOf(this.deletes, DeleteFile::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("start", this.start).add("length", this.length);
        if (!this.deletes.isEmpty()) {
            helper.add("deleteFiles", this.deletes.size());
            helper.add("deleteRecords", this.deletes.stream().mapToLong(DeleteFile::recordCount).sum());
        }
        return helper.toString();
    }
}

