/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.math.LongMath;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.util.DataFileWithDeleteFiles;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.SplitWeight;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private static final ConnectorSplitSource.ConnectorSplitBatch EMPTY_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false);
    private static final ConnectorSplitSource.ConnectorSplitBatch NO_MORE_SPLITS_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), true);
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ConnectorSession session;
    private final IcebergTableHandle tableHandle;
    private final TableScan tableScan;
    private final Optional<Long> maxScannedFileSizeInBytes;
    private final Map<Integer, Type.PrimitiveType> fieldIdToType;
    private final DynamicFilter dynamicFilter;
    private final long dynamicFilteringWaitTimeoutMillis;
    private final Stopwatch dynamicFilterWaitStopwatch;
    private final Constraint constraint;
    private final TypeManager typeManager;
    private final Closer closer = Closer.create();
    private final double minimumAssignedSplitWeight;
    private final Set<Integer> projectedBaseColumns;
    private final TupleDomain<IcebergColumnHandle> dataColumnPredicate;
    private final Domain pathDomain;
    private final Domain fileModifiedTimeDomain;
    private final OptionalLong limit;
    private TupleDomain<IcebergColumnHandle> pushedDownDynamicFilterPredicate;
    private CloseableIterable<FileScanTask> fileScanIterable;
    private long targetSplitSize;
    private CloseableIterator<FileScanTask> fileScanIterator;
    private Iterator<FileScanTask> fileTasksIterator = Collections.emptyIterator();
    private boolean fileHasAnyDeletions;
    private final boolean recordScannedFiles;
    private final ImmutableSet.Builder<DataFileWithDeleteFiles> scannedFiles = ImmutableSet.builder();
    private long outputRowsLowerBound;

    public IcebergSplitSource(TrinoFileSystemFactory fileSystemFactory, ConnectorSession session, IcebergTableHandle tableHandle, TableScan tableScan, Optional<DataSize> maxScannedFileSize, DynamicFilter dynamicFilter, Duration dynamicFilteringWaitTimeout, Constraint constraint, TypeManager typeManager, boolean recordScannedFiles, double minimumAssignedSplitWeight) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.maxScannedFileSizeInBytes = maxScannedFileSize.map(DataSize::toBytes);
        this.fieldIdToType = IcebergUtil.primitiveFieldTypes(tableScan.schema());
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.dynamicFilteringWaitTimeoutMillis = dynamicFilteringWaitTimeout.toMillis();
        this.dynamicFilterWaitStopwatch = Stopwatch.createStarted();
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.recordScannedFiles = recordScannedFiles;
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        this.projectedBaseColumns = (Set)tableHandle.getProjectedColumns().stream().map(column -> column.getBaseColumnIdentity().getId()).collect(ImmutableSet.toImmutableSet());
        this.dataColumnPredicate = tableHandle.getEnforcedPredicate().filter((column, domain) -> !IcebergMetadataColumn.isMetadataColumnId(column.getId()));
        this.pathDomain = IcebergSplitSource.getPathDomain(tableHandle.getEnforcedPredicate());
        Preconditions.checkArgument((tableHandle.getUnenforcedPredicate().isAll() || tableHandle.getLimit().isEmpty() ? 1 : 0) != 0, (String)"Cannot enforce LIMIT %s with unenforced predicate %s present", (Object)tableHandle.getLimit(), tableHandle.getUnenforcedPredicate());
        this.limit = tableHandle.getLimit();
        this.fileModifiedTimeDomain = IcebergSplitSource.getFileModifiedTimePathDomain(tableHandle.getEnforcedPredicate());
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        TupleDomain dynamicFilterPredicate;
        long timeLeft = this.dynamicFilteringWaitTimeoutMillis - this.dynamicFilterWaitStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (this.dynamicFilter.isAwaitable() && timeLeft > 0L) {
            return ((CompletableFuture)this.dynamicFilter.isBlocked().thenApply(ignored -> EMPTY_BATCH)).completeOnTimeout(EMPTY_BATCH, timeLeft, TimeUnit.MILLISECONDS);
        }
        if (this.fileScanIterable == null) {
            TupleDomain effectivePredicate;
            boolean usedSimplifiedPredicate;
            boolean dynamicFilterIsComplete = this.dynamicFilter.isComplete();
            this.pushedDownDynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast);
            TupleDomain fullPredicate = this.tableHandle.getUnenforcedPredicate().intersect(this.pushedDownDynamicFilterPredicate);
            TupleDomain simplifiedPredicate = fullPredicate.simplify(1000);
            boolean bl = usedSimplifiedPredicate = !simplifiedPredicate.equals((Object)fullPredicate);
            if (usedSimplifiedPredicate) {
                this.pushedDownDynamicFilterPredicate = TupleDomain.all();
            }
            if ((effectivePredicate = this.dataColumnPredicate.intersect(simplifiedPredicate)).isNone()) {
                this.finish();
                return CompletableFuture.completedFuture(NO_MORE_SPLITS_BATCH);
            }
            Expression filterExpression = ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)effectivePredicate);
            boolean requiresColumnStats = usedSimplifiedPredicate || !dynamicFilterIsComplete;
            TableScan scan = (TableScan)this.tableScan.filter(filterExpression);
            if (requiresColumnStats) {
                scan = (TableScan)scan.includeColumnStats();
            }
            this.fileScanIterable = (CloseableIterable)this.closer.register((Closeable)scan.planFiles());
            this.targetSplitSize = IcebergSessionProperties.getSplitSize(this.session).map(DataSize::toBytes).orElseGet(() -> ((TableScan)this.tableScan).targetSplitSize());
            this.fileScanIterator = (CloseableIterator)this.closer.register((Closeable)this.fileScanIterable.iterator());
            this.fileTasksIterator = Collections.emptyIterator();
        }
        if ((dynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast)).isNone()) {
            this.finish();
            return CompletableFuture.completedFuture(NO_MORE_SPLITS_BATCH);
        }
        ArrayList<IcebergSplit> splits = new ArrayList<IcebergSplit>(maxSize);
        while (splits.size() < maxSize && (this.fileTasksIterator.hasNext() || this.fileScanIterator.hasNext())) {
            long fileModifiedTime;
            if (!this.fileTasksIterator.hasNext()) {
                FileScanTask wholeFileTask = (FileScanTask)this.fileScanIterator.next();
                this.fileTasksIterator = wholeFileTask.deletes().isEmpty() && this.noDataColumnsProjected(wholeFileTask) ? List.of(wholeFileTask).iterator() : wholeFileTask.split(this.targetSplitSize).iterator();
                this.fileHasAnyDeletions = false;
                continue;
            }
            FileScanTask scanTask = this.fileTasksIterator.next();
            boolean bl = this.fileHasAnyDeletions = this.fileHasAnyDeletions || !scanTask.deletes().isEmpty();
            if (scanTask.deletes().isEmpty() && this.maxScannedFileSizeInBytes.isPresent() && ((DataFile)scanTask.file()).fileSizeInBytes() > this.maxScannedFileSizeInBytes.get() || !this.pathDomain.includesNullableValue((Object)Slices.utf8Slice((String)((DataFile)scanTask.file()).path().toString())) || !this.fileModifiedTimeDomain.isAll() && !this.fileModifiedTimeDomain.includesNullableValue((Object)DateTimeEncoding.packDateTimeWithZone((long)(fileModifiedTime = this.getModificationTime(((DataFile)scanTask.file()).path().toString())), (TimeZoneKey)TimeZoneKey.UTC_KEY))) continue;
            IcebergSplit icebergSplit = this.toIcebergSplit(scanTask);
            Schema fileSchema = scanTask.spec().schema();
            Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(scanTask);
            Set identityPartitionColumns = (Set)partitionKeys.keySet().stream().map(fieldId -> IcebergUtil.getColumnHandle(fileSchema.findField(fieldId.intValue()), this.typeManager)).collect(ImmutableSet.toImmutableSet());
            com.google.common.base.Supplier partitionValues = Suppliers.memoize(() -> IcebergUtil.getPartitionValues(identityPartitionColumns, partitionKeys));
            if (!dynamicFilterPredicate.isAll() && !dynamicFilterPredicate.equals(this.pushedDownDynamicFilterPredicate) && (!IcebergSplitSource.partitionMatchesPredicate(identityPartitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)partitionValues, (TupleDomain<IcebergColumnHandle>)dynamicFilterPredicate) || !IcebergSplitSource.fileMatchesPredicate(this.fieldIdToType, (TupleDomain<IcebergColumnHandle>)dynamicFilterPredicate, ((DataFile)scanTask.file()).lowerBounds(), ((DataFile)scanTask.file()).upperBounds(), ((DataFile)scanTask.file()).nullValueCounts())) || !IcebergSplitSource.partitionMatchesConstraint(identityPartitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)partitionValues, this.constraint)) continue;
            if (this.recordScannedFiles) {
                Object fullyAppliedDeletes = this.tableHandle.getEnforcedPredicate().isAll() ? scanTask.deletes() : ImmutableList.of();
                this.scannedFiles.add((Object)new DataFileWithDeleteFiles((DataFile)scanTask.file(), (List<org.apache.iceberg.DeleteFile>)fullyAppliedDeletes));
            }
            if (!this.fileTasksIterator.hasNext() && !this.fileHasAnyDeletions) {
                this.outputRowsLowerBound = LongMath.saturatedAdd((long)this.outputRowsLowerBound, (long)((DataFile)scanTask.file()).recordCount());
                if (this.limit.isPresent() && this.limit.getAsLong() <= this.outputRowsLowerBound) {
                    this.finish();
                }
            }
            splits.add(icebergSplit);
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    private boolean noDataColumnsProjected(FileScanTask fileScanTask) {
        return ((ImmutableSet)fileScanTask.spec().fields().stream().filter(partitionField -> partitionField.transform().isIdentity()).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet())).containsAll(this.projectedBaseColumns);
    }

    private long getModificationTime(String path) {
        try {
            TrinoInputFile inputFile = this.fileSystemFactory.create(this.session).newInputFile(Location.of((String)path));
            return inputFile.lastModified().toEpochMilli();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to get file modification time: " + path, (Throwable)e);
        }
    }

    private void finish() {
        this.close();
        this.fileScanIterable = CloseableIterable.empty();
        this.fileScanIterator = CloseableIterator.empty();
        this.fileTasksIterator = Collections.emptyIterator();
    }

    public boolean isFinished() {
        return this.fileScanIterator != null && !this.fileScanIterator.hasNext() && !this.fileTasksIterator.hasNext();
    }

    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        Preconditions.checkState((boolean)this.isFinished(), (Object)"Split source must be finished before TableExecuteSplitsInfo is read");
        if (!this.recordScannedFiles) {
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf((Collection)this.scannedFiles.build()));
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    static boolean fileMatchesPredicate(Map<Integer, Type.PrimitiveType> primitiveTypeForFieldId, TupleDomain<IcebergColumnHandle> dynamicFilterPredicate, @Nullable Map<Integer, ByteBuffer> lowerBounds, @Nullable Map<Integer, ByteBuffer> upperBounds, @Nullable Map<Integer, Long> nullValueCounts) {
        if (dynamicFilterPredicate.isNone()) {
            return false;
        }
        Map domains = (Map)dynamicFilterPredicate.getDomains().orElseThrow();
        for (Map.Entry domainEntry : domains.entrySet()) {
            Long nullValueCount;
            IcebergColumnHandle column = (IcebergColumnHandle)domainEntry.getKey();
            Domain domain = (Domain)domainEntry.getValue();
            int fieldId = column.getId();
            boolean mayContainNulls = nullValueCounts == null ? true : (nullValueCount = nullValueCounts.get(fieldId)) == null || nullValueCount > 0L;
            Type type = (Type)primitiveTypeForFieldId.get(fieldId);
            Domain statisticsDomain = IcebergSplitSource.domainForStatistics(column, lowerBounds == null ? null : Conversions.fromByteBuffer((Type)type, (ByteBuffer)lowerBounds.get(fieldId)), upperBounds == null ? null : Conversions.fromByteBuffer((Type)type, (ByteBuffer)upperBounds.get(fieldId)), mayContainNulls);
            if (domain.overlaps(statisticsDomain)) continue;
            return false;
        }
        return true;
    }

    private static Domain domainForStatistics(IcebergColumnHandle columnHandle, @Nullable Object lowerBound, @Nullable Object upperBound, boolean mayContainNulls) {
        io.trino.spi.type.Type type = columnHandle.getType();
        Type icebergType = TypeConverter.toIcebergType(type, columnHandle.getColumnIdentity());
        if (lowerBound == null && upperBound == null) {
            return Domain.create((ValueSet)ValueSet.all((io.trino.spi.type.Type)type), (boolean)mayContainNulls);
        }
        Range statisticsRange = lowerBound != null && upperBound != null ? Range.range((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, lowerBound), (boolean)true, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, upperBound), (boolean)true) : (upperBound != null ? Range.lessThanOrEqual((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, upperBound)) : Range.greaterThanOrEqual((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, lowerBound)));
        return Domain.create((ValueSet)ValueSet.ofRanges((Range)statisticsRange, (Range[])new Range[0]), (boolean)mayContainNulls);
    }

    static boolean partitionMatchesConstraint(Set<IcebergColumnHandle> identityPartitionColumns, Supplier<Map<ColumnHandle, NullableValue>> partitionValues, Constraint constraint) {
        Verify.verify((boolean)constraint.getSummary().isAll());
        if (constraint.predicate().isEmpty() || Sets.intersection((Set)((Set)constraint.getPredicateColumns().orElseThrow()), identityPartitionColumns).isEmpty()) {
            return true;
        }
        return ((Predicate)constraint.predicate().get()).test(partitionValues.get());
    }

    @VisibleForTesting
    static boolean partitionMatchesPredicate(Set<IcebergColumnHandle> identityPartitionColumns, Supplier<Map<ColumnHandle, NullableValue>> partitionValues, TupleDomain<IcebergColumnHandle> dynamicFilterPredicate) {
        if (dynamicFilterPredicate.isNone()) {
            return false;
        }
        Map domains = (Map)dynamicFilterPredicate.getDomains().orElseThrow();
        for (IcebergColumnHandle partitionColumn : identityPartitionColumns) {
            Domain allowedDomain = (Domain)domains.get(partitionColumn);
            if (allowedDomain == null || allowedDomain.includesNullableValue(partitionValues.get().get(partitionColumn).getValue())) continue;
            return false;
        }
        return true;
    }

    private IcebergSplit toIcebergSplit(FileScanTask task) {
        return new IcebergSplit(((DataFile)task.file()).path().toString(), task.start(), task.length(), ((DataFile)task.file()).fileSizeInBytes(), ((DataFile)task.file()).recordCount(), IcebergFileFormat.fromIceberg(((DataFile)task.file()).format()), PartitionSpecParser.toJson((PartitionSpec)task.spec()), PartitionData.toJson(((DataFile)task.file()).partition()), (List)task.deletes().stream().map(DeleteFile::fromIceberg).collect(ImmutableList.toImmutableList()), SplitWeight.fromProportion((double)Math.min(Math.max((double)task.length() / (double)this.tableScan.targetSplitSize(), this.minimumAssignedSplitWeight), 1.0)));
    }

    private static Domain getPathDomain(TupleDomain<IcebergColumnHandle> effectivePredicate) {
        IcebergColumnHandle pathColumn = IcebergColumnHandle.pathColumnHandle();
        Domain domain = (Domain)((Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Unexpected NONE tuple domain"))).get(pathColumn);
        if (domain == null) {
            return Domain.all((io.trino.spi.type.Type)pathColumn.getType());
        }
        return domain;
    }

    private static Domain getFileModifiedTimePathDomain(TupleDomain<IcebergColumnHandle> effectivePredicate) {
        IcebergColumnHandle fileModifiedTimeColumn = IcebergColumnHandle.fileModifiedTimeColumnHandle();
        Domain domain = (Domain)((Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Unexpected NONE tuple domain"))).get(fileModifiedTimeColumn);
        if (domain == null) {
            return Domain.all((io.trino.spi.type.Type)fileModifiedTimeColumn.getType());
        }
        return domain;
    }
}

