/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import com.google.inject.Inject;
import io.trino.plugin.base.io.ByteBuffers;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.CollectedStatistics;
import io.trino.plugin.iceberg.TableStatisticsReader;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinReader;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class TableStatisticsWriter {
    private final String trinoVersion;

    @Inject
    public TableStatisticsWriter(NodeVersion nodeVersion) {
        this.trinoVersion = nodeVersion.toString();
    }

    public StatisticsFile writeStatisticsFile(ConnectorSession session, Table table, long snapshotId, StatsUpdateMode updateMode, CollectedStatistics collectedStatistics) {
        GenericStatisticsFile genericStatisticsFile;
        block10: {
            Snapshot snapshot = table.snapshot(snapshotId);
            TableOperations operations = ((HasTableOperations)table).operations();
            FileIO fileIO = operations.io();
            long snapshotSequenceNumber = snapshot.sequenceNumber();
            Schema schema = (Schema)table.schemas().get(snapshot.schemaId());
            collectedStatistics = this.mergeStatisticsIfNecessary(table, snapshotId, fileIO, updateMode, collectedStatistics);
            Map<Integer, CompactSketch> ndvSketches = collectedStatistics.ndvSketches();
            Set validFieldIds = (Set)Streams.stream((Iterable)Traverser.forTree(nestedField -> {
                Type type = nestedField.type();
                if (type instanceof Type.NestedType) {
                    Type.NestedType nestedType = (Type.NestedType)type;
                    return nestedType.fields();
                }
                if (type instanceof Type.PrimitiveType) {
                    return ImmutableList.of();
                }
                throw new IllegalArgumentException("Unrecognized type for field %s: %s".formatted(nestedField, type));
            }).depthFirstPreOrder((Iterable)schema.columns())).map(Types.NestedField::fieldId).collect(ImmutableSet.toImmutableSet());
            String path = operations.metadataFileLocation(String.format("%s-%s.stats", session.getQueryId(), UUID.randomUUID()));
            OutputFile outputFile = fileIO.newOutputFile(path);
            PuffinWriter writer = Puffin.write((OutputFile)outputFile).createdBy("Trino version " + this.trinoVersion).build();
            try {
                TableStatisticsReader.getLatestStatisticsFile(table, snapshotId).ifPresent(previousStatisticsFile -> this.copyRetainedStatistics(fileIO, (StatisticsFile)previousStatisticsFile, validFieldIds, ndvSketches.keySet(), writer));
                ndvSketches.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
                    Integer fieldId = (Integer)entry.getKey();
                    CompactSketch sketch = (CompactSketch)entry.getValue();
                    long ndvEstimate = (long)sketch.getEstimate();
                    writer.add(new Blob("apache-datasketches-theta-v1", (List)ImmutableList.of((Object)fieldId), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap(sketch.toByteArray()), PuffinCompressionCodec.ZSTD, (Map)ImmutableMap.of((Object)"ndv", (Object)Long.toString(ndvEstimate))));
                });
                writer.finish();
                genericStatisticsFile = new GenericStatisticsFile(snapshotId, path, writer.fileSize(), writer.footerSize(), (List)writer.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        throw new UncheckedIOException(exception);
                    }
                }
                catch (Throwable throwable3) {
                    Closables.closeAllSuppress((Throwable)throwable3, (AutoCloseable[])new AutoCloseable[]{() -> fileIO.deleteFile(path)});
                    throw throwable3;
                }
            }
            writer.close();
        }
        return genericStatisticsFile;
    }

    private CollectedStatistics mergeStatisticsIfNecessary(Table table, long snapshotId, FileIO fileIO, StatsUpdateMode updateMode, CollectedStatistics collectedStatistics) {
        if (updateMode == StatsUpdateMode.INCREMENTAL_UPDATE) {
            Snapshot snapshot = table.snapshot(snapshotId);
            Preconditions.checkState((snapshot != null ? 1 : 0) != 0, (String)"No snapshot information for snapshotId %s in table %s", (long)snapshotId, (Object)table);
            if (snapshot.parentId() == null || !TableStatisticsWriter.maySnapshotHaveData(table, snapshot.parentId(), fileIO)) {
                updateMode = StatsUpdateMode.REPLACE;
            }
        }
        return switch (updateMode) {
            default -> throw new IncompatibleClassChangeError();
            case StatsUpdateMode.REPLACE -> {
                CollectedStatistics var7_6;
                yield var7_6 = collectedStatistics;
            }
            case StatsUpdateMode.INCREMENTAL_UPDATE -> {
                CollectedStatistics var7_6;
                Optional<StatisticsFile> latestStatisticsFile = TableStatisticsReader.getLatestStatisticsFile(table, snapshotId);
                ImmutableMap.Builder ndvSketches = ImmutableMap.builder();
                if (latestStatisticsFile.isPresent()) {
                    Map<Integer, CompactSketch> collectedNdvSketches = collectedStatistics.ndvSketches();
                    Set<Integer> columnsWithRecentlyComputedStats = collectedNdvSketches.keySet();
                    StatisticsFile statisticsFile = latestStatisticsFile.get();
                    boolean hasUsefulData = statisticsFile.blobMetadata().stream().filter(blobMetadata -> blobMetadata.type().equals("apache-datasketches-theta-v1")).filter(blobMetadata -> blobMetadata.fields().size() == 1).anyMatch(blobMetadata -> columnsWithRecentlyComputedStats.contains(Iterables.getOnlyElement((Iterable)blobMetadata.fields())));
                    if (hasUsefulData) {
                        try (PuffinReader reader = Puffin.read((InputFile)fileIO.newInputFile(statisticsFile.path())).withFileSize(statisticsFile.fileSizeInBytes()).withFooterSize(statisticsFile.fileFooterSizeInBytes()).build();){
                            List toRead = (List)reader.fileMetadata().blobs().stream().filter(blobMetadata -> blobMetadata.type().equals("apache-datasketches-theta-v1")).filter(blobMetadata -> blobMetadata.inputFields().size() == 1).filter(blobMetadata -> columnsWithRecentlyComputedStats.contains(Iterables.getOnlyElement((Iterable)blobMetadata.inputFields()))).collect(ImmutableList.toImmutableList());
                            for (Pair read : reader.readAll(toRead)) {
                                Integer fieldId = (Integer)Iterables.getOnlyElement((Iterable)((BlobMetadata)read.first()).inputFields());
                                Memory memory = Memory.wrap((byte[])ByteBuffers.getBytes((ByteBuffer)((ByteBuffer)read.second())));
                                CompactSketch previousSketch = CompactSketch.wrap((Memory)memory);
                                CompactSketch newSketch = Objects.requireNonNull(collectedNdvSketches.get(fieldId), "ndvSketches.get(fieldId) is null");
                                ndvSketches.put((Object)fieldId, (Object)SetOperation.builder().buildUnion().union((Sketch)previousSketch, (Sketch)newSketch));
                            }
                        }
                        catch (IOException exception) {
                            throw new UncheckedIOException(exception);
                        }
                    }
                }
                yield var7_6 = new CollectedStatistics((Map<Integer, CompactSketch>)ndvSketches.buildOrThrow());
            }
        };
    }

    private void copyRetainedStatistics(FileIO fileIO, StatisticsFile previousStatisticsFile, Set<Integer> validFieldIds, Set<Integer> columnsWithNewNdvSketches, PuffinWriter writer) {
        boolean anythingRetained = previousStatisticsFile.blobMetadata().stream().anyMatch(blobMetadata -> this.isBlobRetained(blobMetadata.type(), blobMetadata.fields(), validFieldIds, columnsWithNewNdvSketches));
        if (anythingRetained) {
            try (PuffinReader reader = Puffin.read((InputFile)fileIO.newInputFile(previousStatisticsFile.path())).withFileSize(previousStatisticsFile.fileSizeInBytes()).withFooterSize(previousStatisticsFile.fileFooterSizeInBytes()).build();){
                List retained = (List)reader.fileMetadata().blobs().stream().filter(blobMetadata -> this.isBlobRetained(blobMetadata.type(), blobMetadata.inputFields(), validFieldIds, columnsWithNewNdvSketches)).collect(ImmutableList.toImmutableList());
                for (Pair read : reader.readAll(retained)) {
                    String compressionCodec = ((BlobMetadata)read.first()).compressionCodec();
                    writer.add(new Blob(((BlobMetadata)read.first()).type(), ((BlobMetadata)read.first()).inputFields(), ((BlobMetadata)read.first()).snapshotId(), ((BlobMetadata)read.first()).sequenceNumber(), (ByteBuffer)read.second(), compressionCodec == null ? null : TableStatisticsWriter.tryGetCompressionCodec(compressionCodec).orElse(PuffinCompressionCodec.ZSTD), ((BlobMetadata)read.first()).properties()));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static boolean maySnapshotHaveData(Table table, long snapshotId, FileIO fileIo) {
        Snapshot snapshot = table.snapshot(snapshotId);
        if (snapshot.summary().containsKey("total-records")) {
            return Long.parseLong((String)snapshot.summary().get("total-records")) != 0L;
        }
        for (ManifestFile dataManifest : snapshot.dataManifests(fileIo)) {
            if (!dataManifest.hasExistingFiles() && !dataManifest.hasAddedFiles()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static Optional<PuffinCompressionCodec> tryGetCompressionCodec(String name) {
        Objects.requireNonNull(name, "name is null");
        try {
            return Optional.of(PuffinCompressionCodec.forName((String)name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private boolean isBlobRetained(String blobType, List<Integer> fields, Set<Integer> validFieldIds, Set<Integer> columnsWithNewNdvSketches) {
        if (!blobType.equals("apache-datasketches-theta-v1")) {
            return true;
        }
        if (fields.size() != 1) {
            return true;
        }
        Integer fieldId = (Integer)Iterables.getOnlyElement(fields);
        return validFieldIds.contains(fieldId) && !columnsWithNewNdvSketches.contains(fieldId);
    }

    public static enum StatsUpdateMode {
        REPLACE,
        INCREMENTAL_UPDATE;

    }
}

