/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.aggregation;

import com.google.common.base.Verify;
import io.trino.plugin.base.io.ByteBuffers;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.aggregation.DataSketchState;
import io.trino.plugin.iceberg.aggregation.DataSketchStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.TypeUtils;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.datasketches.Family;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

@AggregationFunction(value="$iceberg_theta_stat", hidden=true)
public final class IcebergThetaSketchForStats {
    public static final String NAME = "$iceberg_theta_stat";

    private IcebergThetaSketchForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") io.trino.spi.type.Type type, @AggregationState DataSketchState state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        Verify.verify((!block.isNull(index) ? 1 : 0) != 0, (String)"Input function is not expected to be called on a NULL input", (Object[])new Object[0]);
        Object trinoValue = TypeUtils.readNativeValue((io.trino.spi.type.Type)type, (Block)block, (int)index);
        Type icebergType = TypeConverter.toIcebergTypeForNewColumn(type, new AtomicInteger(1));
        Object icebergValue = IcebergTypes.convertTrinoValueToIceberg(type, trinoValue);
        ByteBuffer byteBuffer = Conversions.toByteBuffer((Type)icebergType, (Object)icebergValue);
        Objects.requireNonNull(byteBuffer, "byteBuffer is null");
        byte[] bytes = ByteBuffers.getBytes((ByteBuffer)byteBuffer);
        IcebergThetaSketchForStats.getOrCreateUpdateSketch(state).update(bytes);
    }

    @CombineFunction
    public static void combine(@AggregationState DataSketchState state, @AggregationState DataSketchState otherState) {
        Union union = SetOperation.builder().buildUnion();
        IcebergThetaSketchForStats.addIfPresent(union, (Sketch)state.getUpdateSketch());
        IcebergThetaSketchForStats.addIfPresent(union, (Sketch)state.getCompactSketch());
        IcebergThetaSketchForStats.addIfPresent(union, (Sketch)otherState.getUpdateSketch());
        IcebergThetaSketchForStats.addIfPresent(union, (Sketch)otherState.getCompactSketch());
        state.setUpdateSketch(null);
        state.setCompactSketch(union.getResult());
    }

    @OutputFunction(value="varbinary")
    public static void output(@AggregationState DataSketchState state, BlockBuilder out) {
        if (state.getUpdateSketch() == null && state.getCompactSketch() == null) {
            IcebergThetaSketchForStats.getOrCreateUpdateSketch(state);
        }
        DataSketchStateSerializer.serializeToVarbinary(state, out);
    }

    private static UpdateSketch getOrCreateUpdateSketch(@AggregationState DataSketchState state) {
        UpdateSketch sketch = state.getUpdateSketch();
        if (sketch == null) {
            sketch = UpdateSketch.builder().setFamily(Family.ALPHA).build();
            state.setUpdateSketch(sketch);
        }
        return sketch;
    }

    private static void addIfPresent(Union union, @Nullable Sketch input) {
        if (input != null) {
            union.union(input);
        }
    }
}

