/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogConfig;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.nessie.TrinoNessieCatalogFactory;
import java.util.Map;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergNessieCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergNessieCatalogConfig.class);
        binder.bind(IcebergTableOperationsProvider.class).to(IcebergNessieTableOperationsProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IcebergTableOperationsProvider.class).withGeneratedName();
        binder.bind(TrinoCatalogFactory.class).to(TrinoNessieCatalogFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TrinoCatalogFactory.class).withGeneratedName();
    }

    @Provides
    @Singleton
    public static NessieIcebergClient createNessieIcebergClient(IcebergNessieCatalogConfig icebergNessieCatalogConfig) {
        return new NessieIcebergClient((NessieApiV1)HttpClientBuilder.builder().withUri(icebergNessieCatalogConfig.getServerUri()).withEnableApiCompatibilityCheck(false).build(NessieApiV1.class), icebergNessieCatalogConfig.getDefaultReferenceName(), null, (Map)ImmutableMap.of());
    }
}

