/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieTableOperations;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;

public class IcebergNessieTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final NessieIcebergClient nessieClient;

    @Inject
    public IcebergNessieTableOperationsProvider(TrinoFileSystemFactory fileSystemFactory, NessieIcebergClient nessieClient) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.nessieClient = Objects.requireNonNull(nessieClient, "nessieClient is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new IcebergNessieTableOperations(this.nessieClient, (FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session)), session, database, table, owner, location);
    }
}

