/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.delete.DeleteFilter;
import io.trino.plugin.iceberg.delete.LazyTrinoRow;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.plugin.iceberg.delete.TrinoRow;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.iceberg.StructLike;

public final class EqualityDeleteFilter
implements DeleteFilter {
    private final Predicate<StructLike> deletedRows;

    public EqualityDeleteFilter(Predicate<StructLike> deletedRows) {
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
    }

    @Override
    public RowPredicate createPredicate(List<IcebergColumnHandle> columns) {
        Type[] types = (Type[])columns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
        return (page, position) -> {
            LazyTrinoRow row = new LazyTrinoRow(types, page, position);
            return !this.deletedRows.test(row);
        };
    }

    public static void readEqualityDeletes(ConnectorPageSource pageSource, List<IcebergColumnHandle> columns, Consumer<StructLike> deletedRows) {
        Type[] types = (Type[])columns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            for (int position = 0; position < page.getPositionCount(); ++position) {
                deletedRows.accept(new TrinoRow(types, page, position));
            }
        }
    }
}

