/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record TableChangesSplit(ChangeType changeType, long snapshotId, long snapshotTimestamp, int changeOrdinal, String path, long start, long length, long fileSize, long fileRecordCount, IcebergFileFormat fileFormat, List<HostAddress> addresses, String partitionSpecJson, String partitionDataJson, SplitWeight splitWeight) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableChangesSplit.class);

    public TableChangesSplit {
        Objects.requireNonNull(changeType, "changeType is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(fileFormat, "fileFormat is null");
        addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        Objects.requireNonNull(partitionSpecJson, "partitionSpecJson is null");
        Objects.requireNonNull(partitionDataJson, "partitionDataJson is null");
        Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.partitionSpecJson) + SizeOf.estimatedSizeOf((String)this.partitionDataJson) + this.splitWeight.getRetainedSizeInBytes();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("start", this.start).add("length", this.length).add("records", this.fileRecordCount).toString();
    }

    public static enum ChangeType {
        ADDED_FILE("insert"),
        DELETED_FILE("delete"),
        POSITIONAL_DELETE("delete");

        private final String tableValue;

        private ChangeType(String tableValue) {
            this.tableValue = tableValue;
        }

        public String getTableValue() {
            return this.tableValue;
        }
    }
}

