/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalLogId;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.GracefulSwitchLoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.InternalXdsAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Locality;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.WeightedTargetLoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsSubchannelPickers;
import java.util.HashMap;
import java.util.Objects;

final class WrrLocalityLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final GracefulSwitchLoadBalancer switchLb;
    private final LoadBalancerRegistry lbRegistry;

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.lbRegistry = lbRegistry;
        this.switchLb = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("xds-wrr-locality-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        WrrLocalityConfig wrrLocalityConfig = (WrrLocalityConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Locality, Integer> localityWeights = new HashMap<Locality, Integer>();
        for (EquivalentAddressGroup eag : resolvedAddresses.getAddresses()) {
            Attributes eagAttrs = eag.getAttributes();
            Locality locality = eagAttrs.get(InternalXdsAttributes.ATTR_LOCALITY);
            Integer localityWeight = eagAttrs.get(InternalXdsAttributes.ATTR_LOCALITY_WEIGHT);
            if (locality == null) {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("wrr_locality error: no locality provided")));
                return false;
            }
            if (localityWeight == null) {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("wrr_locality error: no weight provided for locality " + locality)));
                return false;
            }
            if (!localityWeights.containsKey(locality)) {
                localityWeights.put(locality, localityWeight);
                continue;
            }
            if (((Integer)localityWeights.get(locality)).equals(localityWeight)) continue;
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Locality {0} has both weights {1} and {2}, using weight {1}", locality, localityWeights.get(locality), localityWeight);
        }
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> weightedPolicySelections = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (Locality locality : localityWeights.keySet()) {
            weightedPolicySelections.put(locality.toString(), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection((Integer)localityWeights.get(locality), wrrLocalityConfig.childPolicy));
        }
        this.switchLb.switchTo(this.lbRegistry.getProvider("weighted_target_experimental"));
        this.switchLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(weightedPolicySelections)).build());
        return true;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchLb.handleNameResolutionError(error);
    }

    @Override
    public void shutdown() {
        this.switchLb.shutdown();
    }

    static final class WrrLocalityConfig {
        final ServiceConfigUtil.PolicySelection childPolicy;

        WrrLocalityConfig(ServiceConfigUtil.PolicySelection childPolicy) {
            this.childPolicy = childPolicy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrrLocalityConfig that = (WrrLocalityConfig)o;
            return Objects.equals(this.childPolicy, that.childPolicy);
        }

        public int hashCode() {
            return Objects.hashCode(this.childPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childPolicy", this.childPolicy).toString();
        }
    }
}

