/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.checkpoint;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.orc.checkpoint.Checkpoints;
import io.trino.orc.checkpoint.InputStreamCheckpoint;
import io.trino.orc.checkpoint.LongStreamCheckpoint;
import java.util.List;

public final class LongStreamV2Checkpoint
implements LongStreamCheckpoint {
    private final int offset;
    private final long inputStreamCheckpoint;

    public LongStreamV2Checkpoint(int offset, long inputStreamCheckpoint) {
        this.offset = offset;
        this.inputStreamCheckpoint = inputStreamCheckpoint;
    }

    public LongStreamV2Checkpoint(boolean compressed, Checkpoints.ColumnPositionsList positionsList) {
        this.inputStreamCheckpoint = InputStreamCheckpoint.createInputStreamCheckpoint(compressed, positionsList);
        this.offset = positionsList.nextPosition();
    }

    public int getOffset() {
        return this.offset;
    }

    public long getInputStreamCheckpoint() {
        return this.inputStreamCheckpoint;
    }

    @Override
    public List<Integer> toPositionList(boolean compressed) {
        return ImmutableList.builder().addAll(InputStreamCheckpoint.createInputStreamPositionList(compressed, this.inputStreamCheckpoint)).add((Object)this.offset).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("inputStreamCheckpoint", (Object)InputStreamCheckpoint.inputStreamCheckpointToString(this.inputStreamCheckpoint)).toString();
    }
}

