/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.DelegatingOutputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;

class ParquetIO {
    private ParquetIO() {
    }

    static org.apache.parquet.io.InputFile file(InputFile file) {
        if (file instanceof HadoopInputFile) {
            HadoopInputFile hfile = (HadoopInputFile)file;
            try {
                return org.apache.parquet.hadoop.util.HadoopInputFile.fromStatus((FileStatus)hfile.getStat(), (Configuration)hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet input file for %s", new Object[]{file});
            }
        }
        return new ParquetInputFile(file);
    }

    static OutputFile file(org.apache.iceberg.io.OutputFile file) {
        if (file instanceof org.apache.iceberg.hadoop.HadoopOutputFile) {
            org.apache.iceberg.hadoop.HadoopOutputFile hfile = (org.apache.iceberg.hadoop.HadoopOutputFile)file;
            try {
                return HadoopOutputFile.fromPath((Path)hfile.getPath(), (Configuration)hfile.getConf());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", new Object[]{file});
            }
        }
        return new ParquetOutputFile(file);
    }

    static OutputFile file(org.apache.iceberg.io.OutputFile file, Configuration conf) {
        if (file instanceof org.apache.iceberg.hadoop.HadoopOutputFile) {
            org.apache.iceberg.hadoop.HadoopOutputFile hfile = (org.apache.iceberg.hadoop.HadoopOutputFile)file;
            try {
                return HadoopOutputFile.fromPath((Path)hfile.getPath(), (Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create Parquet output file for %s", new Object[]{file});
            }
        }
        return new ParquetOutputFile(file);
    }

    static SeekableInputStream stream(org.apache.iceberg.io.SeekableInputStream stream) {
        InputStream wrapped;
        if (stream instanceof DelegatingInputStream && (wrapped = ((DelegatingInputStream)stream).getDelegate()) instanceof FSDataInputStream) {
            return HadoopStreams.wrap((FSDataInputStream)((FSDataInputStream)wrapped));
        }
        return new ParquetInputStreamAdapter(stream);
    }

    static PositionOutputStream stream(org.apache.iceberg.io.PositionOutputStream stream) {
        OutputStream wrapped;
        if (stream instanceof DelegatingOutputStream && (wrapped = ((DelegatingOutputStream)stream).getDelegate()) instanceof FSDataOutputStream) {
            return HadoopStreams.wrap((FSDataOutputStream)((FSDataOutputStream)wrapped));
        }
        return new ParquetOutputStreamAdapter(stream);
    }

    private static class ParquetInputFile
    implements org.apache.parquet.io.InputFile {
        private final InputFile file;

        private ParquetInputFile(InputFile file) {
            this.file = file;
        }

        public long getLength() throws IOException {
            return this.file.getLength();
        }

        public SeekableInputStream newStream() throws IOException {
            return ParquetIO.stream(this.file.newStream());
        }
    }

    private static class ParquetOutputFile
    implements OutputFile {
        private final org.apache.iceberg.io.OutputFile file;

        private ParquetOutputFile(org.apache.iceberg.io.OutputFile file) {
            this.file = file;
        }

        public PositionOutputStream create(long ignored) throws IOException {
            return ParquetIO.stream(this.file.create());
        }

        public PositionOutputStream createOrOverwrite(long ignored) throws IOException {
            return ParquetIO.stream(this.file.createOrOverwrite());
        }

        public boolean supportsBlockSize() {
            return false;
        }

        public long defaultBlockSize() {
            return 0L;
        }
    }

    private static class ParquetOutputStreamAdapter
    extends DelegatingPositionOutputStream {
        private final org.apache.iceberg.io.PositionOutputStream delegate;

        private ParquetOutputStreamAdapter(org.apache.iceberg.io.PositionOutputStream delegate) {
            super((OutputStream)delegate);
            this.delegate = delegate;
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }
    }

    private static class ParquetInputStreamAdapter
    extends DelegatingSeekableInputStream {
        private final org.apache.iceberg.io.SeekableInputStream delegate;

        private ParquetInputStreamAdapter(org.apache.iceberg.io.SeekableInputStream delegate) {
            super((InputStream)delegate);
            this.delegate = delegate;
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }
    }
}

