/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.local.LocalUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class LocalFileIterator
implements FileIterator {
    private final Path rootPath;
    private final Iterator<Path> iterator;

    public LocalFileIterator(Location location, Path rootPath, Path path) throws IOException {
        this.rootPath = Objects.requireNonNull(rootPath, "rootPath is null");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Location is a file: " + String.valueOf(location));
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            this.iterator = Collections.emptyIterator();
        } else {
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                this.iterator = ((ImmutableList)stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(ImmutableList.toImmutableList())).iterator();
            }
            catch (IOException e) {
                throw LocalUtils.handleException(location, e);
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.iterator.hasNext();
    }

    @Override
    public FileEntry next() throws IOException {
        Path path = this.iterator.next();
        if (!path.startsWith(this.rootPath)) {
            throw new IOException("entry is not inside of filesystem root");
        }
        return new FileEntry(Location.of("local:///" + String.valueOf(this.rootPath.relativize(path))), Files.size(path), Files.getLastModifiedTime(path, new LinkOption[0]).toInstant(), Optional.empty());
    }
}

