/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;

public class ConstantPopulatingPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final Block[] constantColumns;
    private final int[] targetChannelToSourceChannel;

    private ConstantPopulatingPageSource(ConnectorPageSource delegate, Block[] constantColumns, int[] targetChannelToSourceChannel) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.constantColumns = Objects.requireNonNull(constantColumns, "constantColumns is null");
        this.targetChannelToSourceChannel = Objects.requireNonNull(targetChannelToSourceChannel, "targetChannelToSourceChannel is null");
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        Page delegatePage = this.delegate.getNextPage();
        if (delegatePage == null) {
            return null;
        }
        int size = this.constantColumns.length;
        Block[] blocks = new Block[size];
        for (int targetChannel = 0; targetChannel < size; ++targetChannel) {
            Block constantValue = this.constantColumns[targetChannel];
            blocks[targetChannel] = constantValue != null ? RunLengthEncodedBlock.create((Block)constantValue, (int)delegatePage.getPositionCount()) : delegatePage.getBlock(this.targetChannelToSourceChannel[targetChannel]);
        }
        return new Page(delegatePage.getPositionCount(), blocks);
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public CompletableFuture<?> isBlocked() {
        return this.delegate.isBlocked();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<ColumnType> columns = ImmutableList.builder();

        private Builder() {
        }

        public Builder addConstantColumn(Block value) {
            this.columns.add((Object)new ConstantColumn(value));
            return this;
        }

        public Builder addDelegateColumn(int sourceChannel) {
            this.columns.add((Object)new DelegateColumn(sourceChannel));
            return this;
        }

        public ConnectorPageSource build(ConnectorPageSource delegate) {
            ImmutableList columns = this.columns.build();
            Block[] constantValues = new Block[columns.size()];
            int[] delegateIndexes = new int[columns.size()];
            boolean isRequired = false;
            for (int columnChannel = 0; columnChannel < columns.size(); ++columnChannel) {
                ColumnType column = (ColumnType)columns.get(columnChannel);
                if (column instanceof ConstantColumn) {
                    constantValues[columnChannel] = ((ConstantColumn)column).getValue();
                    isRequired = true;
                    continue;
                }
                if (column instanceof DelegateColumn) {
                    int delegateChannel;
                    delegateIndexes[columnChannel] = delegateChannel = ((DelegateColumn)column).getSourceChannel();
                    if (columnChannel == delegateChannel) continue;
                    isRequired = true;
                    continue;
                }
                throw new IllegalStateException("Unknown ConstantPopulatingPageSource ColumnType " + String.valueOf(column));
            }
            if (!isRequired) {
                return delegate;
            }
            return new ConstantPopulatingPageSource(delegate, constantValues, delegateIndexes);
        }
    }

    private static class DelegateColumn
    implements ColumnType {
        private final int sourceChannel;

        private DelegateColumn(int sourceChannel) {
            this.sourceChannel = sourceChannel;
        }

        public int getSourceChannel() {
            return this.sourceChannel;
        }
    }

    private static class ConstantColumn
    implements ColumnType {
        private final Block value;

        private ConstantColumn(Block value) {
            this.value = Objects.requireNonNull(value, "value is null");
            Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"ConstantColumn may only contain one value");
        }

        public Block getValue() {
            return this.value;
        }
    }

    public static interface ColumnType {
    }
}

