/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergFileFormat;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"iceberg.allow-legacy-snapshot-syntax", "iceberg.experimental.extended-statistics.enabled"})
public class IcebergConfig {
    public static final int FORMAT_VERSION_SUPPORT_MIN = 1;
    public static final int FORMAT_VERSION_SUPPORT_MAX = 2;
    public static final String EXTENDED_STATISTICS_CONFIG = "iceberg.extended-statistics.enabled";
    public static final String EXTENDED_STATISTICS_DESCRIPTION = "Enable collection (ANALYZE) and use of extended statistics.";
    public static final String COLLECT_EXTENDED_STATISTICS_ON_WRITE_DESCRIPTION = "Collect extended statistics during writes";
    public static final String EXPIRE_SNAPSHOTS_MIN_RETENTION = "iceberg.expire_snapshots.min-retention";
    public static final String REMOVE_ORPHAN_FILES_MIN_RETENTION = "iceberg.remove_orphan_files.min-retention";
    private IcebergFileFormat fileFormat = IcebergFileFormat.PARQUET;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.ZSTD;
    private boolean useFileSizeFromMetadata = true;
    private int maxPartitionsPerWriter = 100;
    private boolean uniqueTableLocation = true;
    private CatalogType catalogType = CatalogType.HIVE_METASTORE;
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.SECONDS);
    private boolean tableStatisticsEnabled = true;
    private boolean extendedStatisticsEnabled = true;
    private boolean collectExtendedStatisticsOnWrite = true;
    private boolean projectionPushdownEnabled = true;
    private boolean registerTableProcedureEnabled;
    private Optional<String> hiveCatalogName = Optional.empty();
    private int formatVersion = 2;
    private Duration expireSnapshotsMinRetention = new Duration(7.0, TimeUnit.DAYS);
    private Duration removeOrphanFilesMinRetention = new Duration(7.0, TimeUnit.DAYS);
    private DataSize targetMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize idleWriterMinFileSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean deleteSchemaLocationsFallback;
    private double minimumAssignedSplitWeight = 0.05;
    private boolean hideMaterializedViewStorageTable = true;
    private Optional<String> materializedViewsStorageSchema = Optional.empty();
    private boolean sortedWritingEnabled = true;
    private boolean queryPartitionFilterRequired;

    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    @NotNull
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @Deprecated
    public boolean isUseFileSizeFromMetadata() {
        return this.useFileSizeFromMetadata;
    }

    @Deprecated
    @Config(value="iceberg.use-file-size-from-metadata")
    public IcebergConfig setUseFileSizeFromMetadata(boolean useFileSizeFromMetadata) {
        this.useFileSizeFromMetadata = useFileSizeFromMetadata;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="iceberg.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public IcebergConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    public boolean isUniqueTableLocation() {
        return this.uniqueTableLocation;
    }

    @Config(value="iceberg.unique-table-location")
    @ConfigDescription(value="Use randomized, unique table locations")
    public IcebergConfig setUniqueTableLocation(boolean uniqueTableLocation) {
        this.uniqueTableLocation = uniqueTableLocation;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="iceberg.dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters during split generation")
    public IcebergConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Config(value="iceberg.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public IcebergConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isExtendedStatisticsEnabled() {
        return this.extendedStatisticsEnabled;
    }

    @Config(value="iceberg.extended-statistics.enabled")
    @ConfigDescription(value="Enable collection (ANALYZE) and use of extended statistics.")
    public IcebergConfig setExtendedStatisticsEnabled(boolean extendedStatisticsEnabled) {
        this.extendedStatisticsEnabled = extendedStatisticsEnabled;
        return this;
    }

    public boolean isCollectExtendedStatisticsOnWrite() {
        return this.collectExtendedStatisticsOnWrite;
    }

    @Config(value="iceberg.extended-statistics.collect-on-write")
    @ConfigDescription(value="Collect extended statistics during writes")
    public IcebergConfig setCollectExtendedStatisticsOnWrite(boolean collectExtendedStatisticsOnWrite) {
        this.collectExtendedStatisticsOnWrite = collectExtendedStatisticsOnWrite;
        return this;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushdownEnabled;
    }

    @Config(value="iceberg.projection-pushdown-enabled")
    @ConfigDescription(value="Read only required fields from a row type")
    public IcebergConfig setProjectionPushdownEnabled(boolean projectionPushdownEnabled) {
        this.projectionPushdownEnabled = projectionPushdownEnabled;
        return this;
    }

    public boolean isRegisterTableProcedureEnabled() {
        return this.registerTableProcedureEnabled;
    }

    @Config(value="iceberg.register-table-procedure.enabled")
    @ConfigDescription(value="Allow users to call the register_table procedure")
    public IcebergConfig setRegisterTableProcedureEnabled(boolean registerTableProcedureEnabled) {
        this.registerTableProcedureEnabled = registerTableProcedureEnabled;
        return this;
    }

    public Optional<String> getHiveCatalogName() {
        return this.hiveCatalogName;
    }

    @Config(value="iceberg.hive-catalog-name")
    @ConfigDescription(value="Catalog to redirect to when a Hive table is referenced")
    public IcebergConfig setHiveCatalogName(String hiveCatalogName) {
        this.hiveCatalogName = Optional.ofNullable(hiveCatalogName);
        return this;
    }

    @Min(value=1L)
    @Max(value=2L)
    public @Min(value=1L) @Max(value=2L) int getFormatVersion() {
        return this.formatVersion;
    }

    @Config(value="iceberg.format-version")
    @ConfigDescription(value="Default Iceberg table format version")
    public IcebergConfig setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    @NotNull
    public Duration getExpireSnapshotsMinRetention() {
        return this.expireSnapshotsMinRetention;
    }

    @Config(value="iceberg.expire_snapshots.min-retention")
    @ConfigDescription(value="Minimal retention period for expire_snapshot procedure")
    public IcebergConfig setExpireSnapshotsMinRetention(Duration expireSnapshotsMinRetention) {
        this.expireSnapshotsMinRetention = expireSnapshotsMinRetention;
        return this;
    }

    @NotNull
    public Duration getRemoveOrphanFilesMinRetention() {
        return this.removeOrphanFilesMinRetention;
    }

    @Config(value="iceberg.remove_orphan_files.min-retention")
    @ConfigDescription(value="Minimal retention period for remove_orphan_files procedure")
    public IcebergConfig setRemoveOrphanFilesMinRetention(Duration removeOrphanFilesMinRetention) {
        this.removeOrphanFilesMinRetention = removeOrphanFilesMinRetention;
        return this;
    }

    public DataSize getTargetMaxFileSize() {
        return this.targetMaxFileSize;
    }

    @LegacyConfig(value={"hive.target-max-file-size"})
    @Config(value="iceberg.target-max-file-size")
    @ConfigDescription(value="Target maximum size of written files; the actual size may be larger")
    public IcebergConfig setTargetMaxFileSize(DataSize targetMaxFileSize) {
        this.targetMaxFileSize = targetMaxFileSize;
        return this;
    }

    @NotNull
    public DataSize getIdleWriterMinFileSize() {
        return this.idleWriterMinFileSize;
    }

    @Config(value="iceberg.idle-writer-min-file-size")
    @ConfigDescription(value="Minimum data written by a single partition writer before it can be consider as 'idle' and could be closed by the engine")
    public IcebergConfig setIdleWriterMinFileSize(DataSize idleWriterMinFileSize) {
        this.idleWriterMinFileSize = idleWriterMinFileSize;
        return this;
    }

    public boolean isDeleteSchemaLocationsFallback() {
        return this.deleteSchemaLocationsFallback;
    }

    @LegacyConfig(value={"hive.delete-schema-locations-fallback"})
    @Config(value="iceberg.delete-schema-locations-fallback")
    @ConfigDescription(value="Whether schema locations should be deleted when Trino can't determine whether they contain external files.")
    public IcebergConfig setDeleteSchemaLocationsFallback(boolean deleteSchemaLocationsFallback) {
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        return this;
    }

    @Config(value="iceberg.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned")
    public IcebergConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    public boolean isHideMaterializedViewStorageTable() {
        return this.hideMaterializedViewStorageTable;
    }

    @Config(value="iceberg.materialized-views.hide-storage-table")
    @ConfigDescription(value="Hide materialized view storage tables in metastore")
    public IcebergConfig setHideMaterializedViewStorageTable(boolean hideMaterializedViewStorageTable) {
        this.hideMaterializedViewStorageTable = hideMaterializedViewStorageTable;
        return this;
    }

    @NotNull
    public Optional<String> getMaterializedViewsStorageSchema() {
        return this.materializedViewsStorageSchema;
    }

    @Config(value="iceberg.materialized-views.storage-schema")
    @ConfigDescription(value="Schema for creating materialized views storage tables")
    public IcebergConfig setMaterializedViewsStorageSchema(String materializedViewsStorageSchema) {
        this.materializedViewsStorageSchema = Optional.ofNullable(materializedViewsStorageSchema);
        return this;
    }

    public boolean isSortedWritingEnabled() {
        return this.sortedWritingEnabled;
    }

    @Config(value="iceberg.sorted-writing-enabled")
    @ConfigDescription(value="Enable sorted writing to tables with a specified sort order")
    public IcebergConfig setSortedWritingEnabled(boolean sortedWritingEnabled) {
        this.sortedWritingEnabled = sortedWritingEnabled;
        return this;
    }

    @Config(value="iceberg.query-partition-filter-required")
    @ConfigDescription(value="Require a filter on at least one partition column")
    public IcebergConfig setQueryPartitionFilterRequired(boolean queryPartitionFilterRequired) {
        this.queryPartitionFilterRequired = queryPartitionFilterRequired;
        return this;
    }

    public boolean isQueryPartitionFilterRequired() {
        return this.queryPartitionFilterRequired;
    }

    @AssertFalse(message="iceberg.materialized-views.storage-schema may only be set when iceberg.materialized-views.hide-storage-table is set to false")
    public @AssertFalse(message="iceberg.materialized-views.storage-schema may only be set when iceberg.materialized-views.hide-storage-table is set to false") boolean isStorageSchemaSetWhenHidingIsEnabled() {
        return this.hideMaterializedViewStorageTable && this.materializedViewsStorageSchema.isPresent();
    }
}

