/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.base.Versions;
import io.trino.plugin.iceberg.InternalIcebergConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergConnectorFactory
implements ConnectorFactory {
    private final Module module;

    public IcebergConnectorFactory() {
        this(Modules.EMPTY_MODULE);
    }

    public IcebergConnectorFactory(Module module) {
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return "iceberg";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        return InternalIcebergConnectorFactory.createConnector(catalogName, config, context, this.module, Optional.empty(), Optional.empty());
    }
}

