/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.VerifyException;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import org.apache.iceberg.FileFormat;

public enum IcebergFileFormat {
    ORC,
    PARQUET,
    AVRO;


    public FileFormat toIceberg() {
        switch (this.ordinal()) {
            case 0: {
                return FileFormat.ORC;
            }
            case 1: {
                return FileFormat.PARQUET;
            }
            case 2: {
                return FileFormat.AVRO;
            }
        }
        throw new VerifyException("Unhandled type: " + String.valueOf((Object)this));
    }

    public static IcebergFileFormat fromIceberg(FileFormat format) {
        switch (format) {
            case ORC: {
                return ORC;
            }
            case PARQUET: {
                return PARQUET;
            }
            case AVRO: {
                return AVRO;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + String.valueOf(format));
    }
}

