/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IcebergMaterializedViewProperties {
    public static final String STORAGE_SCHEMA = "storage_schema";
    private final List<PropertyMetadata<?>> materializedViewProperties;

    @Inject
    public IcebergMaterializedViewProperties(IcebergConfig icebergConfig, IcebergTableProperties tableProperties) {
        this.materializedViewProperties = ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)STORAGE_SCHEMA, (String)"Schema for creating materialized view storage table", (String)icebergConfig.getMaterializedViewsStorageSchema().orElse(null), (boolean)false)).addAll(tableProperties.getTableProperties()).build();
    }

    public List<PropertyMetadata<?>> getMaterializedViewProperties() {
        return this.materializedViewProperties;
    }

    public static Optional<String> getStorageSchema(Map<String, Object> materializedViewProperties) {
        return Optional.ofNullable((String)materializedViewProperties.get(STORAGE_SCHEMA));
    }
}

