/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Inject;
import io.trino.plugin.iceberg.IcebergBucketFunction;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergUpdateBucketFunction;
import io.trino.plugin.iceberg.IcebergUpdateHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import org.apache.iceberg.Schema;

public class IcebergNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;

    @Inject
    public IcebergNodePartitioningProvider(TypeManager typeManager) {
        this.typeOperators = typeManager.getTypeOperators();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        if (partitioningHandle instanceof IcebergUpdateHandle) {
            return new IcebergUpdateBucketFunction(bucketCount);
        }
        IcebergPartitioningHandle handle = (IcebergPartitioningHandle)partitioningHandle;
        Schema schema = IcebergUtil.schemaFromHandles(handle.getPartitioningColumns());
        return new IcebergBucketFunction(this.typeOperators, PartitionFields.parsePartitionFields(schema, handle.getPartitioning()), handle.getPartitioningColumns(), bucketCount);
    }
}

