/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.plugin.iceberg.util.OrcMetrics;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;

public final class IcebergOrcFileWriter
implements IcebergFileWriter {
    private static final Logger log = Logger.get(IcebergOrcFileWriter.class);
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IcebergOrcFileWriter.class);
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final OrcWriter orcWriter;
    private final Schema icebergSchema;
    private final ColumnMetadata<OrcType> orcColumns;
    private final MetricsConfig metricsConfig;
    private final Closeable rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<OrcDataSource>> validationInputFactory;
    private long validationCpuNanos;

    public IcebergOrcFileWriter(MetricsConfig metricsConfig, Schema icebergSchema, OrcDataSink orcDataSink, Closeable rollbackAction, List<String> columnNames, List<Type> fileColumnTypes, ColumnMetadata<OrcType> fileColumnOrcTypes, CompressionKind compression, OrcWriterOptions options, int[] fileInputColumnIndexes, Map<String, String> metadata, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, OrcWriterStats stats) {
        Objects.requireNonNull(orcDataSink, "orcDataSink is null");
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "fileInputColumnIndexes is null");
        this.nullBlocks = (List)fileColumnTypes.stream().map(type -> type.createBlockBuilder(null, 1, 0).appendNull().build()).collect(ImmutableList.toImmutableList());
        this.validationInputFactory = validationInputFactory;
        this.orcWriter = new OrcWriter(orcDataSink, columnNames, fileColumnTypes, fileColumnOrcTypes, compression, options, metadata, validationInputFactory.isPresent(), validationMode, stats);
        this.icebergSchema = Objects.requireNonNull(icebergSchema, "icebergSchema is null");
        this.metricsConfig = Objects.requireNonNull(metricsConfig, "metricsConfig is null");
        this.orcColumns = fileColumnOrcTypes;
    }

    @Override
    public Metrics getMetrics() {
        return OrcMetrics.computeMetrics(this.metricsConfig, this.icebergSchema, this.orcColumns, this.orcWriter.getFileRowCount(), this.orcWriter.getFileStats());
    }

    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes() + this.orcWriter.getBufferedBytes();
    }

    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.orcWriter.getRetainedBytes();
    }

    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? RunLengthEncodedBlock.create((Block)this.nullBlocks.get(i), (int)dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.orcWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    public Closeable commit() {
        try {
            this.orcWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.close();
            }
            catch (IOException | RuntimeException ex) {
                if (!e.equals(ex)) {
                    e.addSuppressed(ex);
                }
                log.error((Throwable)ex, "Exception when committing file");
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_CLOSE_ERROR, "Error committing write to ORC file", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (OrcDataSource input = this.validationInputFactory.get().get();){
                long startThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                this.orcWriter.validate(input);
                this.validationCpuNanos += THREAD_MX_BEAN.getCurrentThreadCpuTime() - startThreadCpuTime;
            }
            catch (IOException | UncheckedIOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
        return this.rollbackAction;
    }

    public void rollback() {
        try (Closeable closeable = this.rollbackAction;){
            this.orcWriter.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_CLOSE_ERROR, "Error rolling back write to ORC file", (Throwable)e);
        }
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.orcWriter).toString();
    }
}

