/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public final class IcebergParquetFileWriter
implements IcebergFileWriter {
    private final MetricsConfig metricsConfig;
    private final ParquetFileWriter parquetFileWriter;
    private final Location location;

    public IcebergParquetFileWriter(MetricsConfig metricsConfig, TrinoOutputFile outputFile, Closeable rollbackAction, List<Type> fileColumnTypes, List<String> fileColumnNames, MessageType messageType, Map<List<String>, Type> primitiveTypes, ParquetWriterOptions parquetWriterOptions, int[] fileInputColumnIndexes, CompressionCodec compressionCodec, String trinoVersion) throws IOException {
        this.parquetFileWriter = new ParquetFileWriter(outputFile, rollbackAction, fileColumnTypes, fileColumnNames, messageType, primitiveTypes, parquetWriterOptions, fileInputColumnIndexes, compressionCodec, trinoVersion, Optional.empty(), Optional.empty());
        this.location = outputFile.location();
        this.metricsConfig = Objects.requireNonNull(metricsConfig, "metricsConfig is null");
    }

    @Override
    public Metrics getMetrics() {
        ParquetMetadata parquetMetadata;
        try {
            parquetMetadata = new ParquetMetadataConverter().fromParquetMetadata(this.parquetFileWriter.getFileMetadata());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error creating metadata for Parquet file %s", this.location), (Throwable)e);
        }
        return ParquetUtil.footerMetrics((ParquetMetadata)parquetMetadata, Stream.empty(), (MetricsConfig)this.metricsConfig);
    }

    public long getWrittenBytes() {
        return this.parquetFileWriter.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.parquetFileWriter.getMemoryUsage();
    }

    public void appendRows(Page dataPage) {
        this.parquetFileWriter.appendRows(dataPage);
    }

    public Closeable commit() {
        return this.parquetFileWriter.commit();
    }

    public void rollback() {
        this.parquetFileWriter.rollback();
    }

    public long getValidationCpuNanos() {
        return this.parquetFileWriter.getValidationCpuNanos();
    }
}

