/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.iceberg.AsyncIcebergSplitProducer;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTransactionManager;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesSplitSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;

public class IcebergSplitManager
implements ConnectorSplitManager {
    public static final int ICEBERG_DOMAIN_COMPACTION_THRESHOLD = 1000;
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean asyncIcebergSplitProducer;

    @Inject
    public IcebergSplitManager(IcebergTransactionManager transactionManager, TypeManager typeManager, TrinoFileSystemFactory fileSystemFactory, @AsyncIcebergSplitProducer boolean asyncIcebergSplitProducer) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.asyncIcebergSplitProducer = asyncIcebergSplitProducer;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        if (table.getSnapshotId().isEmpty()) {
            if (table.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return FixedSplitSource.emptySplitSource();
        }
        Table icebergTable = this.transactionManager.get(transaction, session.getIdentity()).getIcebergTable(session, table.getSchemaTableName());
        Duration dynamicFilteringWaitTimeout = IcebergSessionProperties.getDynamicFilteringWaitTimeout(session);
        TableScan tableScan = icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue());
        if (!this.asyncIcebergSplitProducer) {
            tableScan = (TableScan)tableScan.planWith((ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        IcebergSplitSource splitSource = new IcebergSplitSource(this.fileSystemFactory, session, table, tableScan, table.getMaxScannedFileSize(), dynamicFilter, dynamicFilteringWaitTimeout, constraint, this.typeManager, table.isRecordScannedFiles(), IcebergSessionProperties.getMinimumAssignedSplitWeight(session));
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, IcebergSplitManager.class.getClassLoader());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle function) {
        if (function instanceof TableChangesFunctionHandle) {
            TableChangesFunctionHandle functionHandle = (TableChangesFunctionHandle)function;
            Table icebergTable = this.transactionManager.get(transaction, session.getIdentity()).getIcebergTable(session, functionHandle.schemaTableName());
            TableChangesSplitSource tableChangesSplitSource = new TableChangesSplitSource(icebergTable, (IncrementalChangelogScan)((IncrementalChangelogScan)icebergTable.newIncrementalChangelogScan().fromSnapshotExclusive(functionHandle.startSnapshotId())).toSnapshot(functionHandle.endSnapshotId()));
            return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)tableChangesSplitSource, IcebergSplitManager.class.getClassLoader());
        }
        throw new IllegalStateException("Unknown table function: " + String.valueOf(function));
    }
}

