/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.math.LongMath;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.io.ByteBuffers;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Objects;
import java.util.UUID;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class IcebergTypes {
    private IcebergTypes() {
    }

    public static Object convertTrinoValueToIceberg(io.trino.spi.type.Type type, Object trinoNativeValue) {
        Objects.requireNonNull(trinoNativeValue, "trinoNativeValue is null");
        if (type == BooleanType.BOOLEAN) {
            return (boolean)((Boolean)trinoNativeValue);
        }
        if (type == IntegerType.INTEGER) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type == BigintType.BIGINT) {
            return (long)((Long)trinoNativeValue);
        }
        if (type == RealType.REAL) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)trinoNativeValue)));
        }
        if (type == DoubleType.DOUBLE) {
            return (double)((Double)trinoNativeValue);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return BigDecimal.valueOf((Long)trinoNativeValue).movePointLeft(decimalType.getScale());
            }
            return new BigDecimal(((Int128)trinoNativeValue).toBigInteger(), decimalType.getScale());
        }
        if (type == DateType.DATE) {
            return Math.toIntExact((Long)trinoNativeValue);
        }
        if (type.equals((Object)TimeType.TIME_MICROS)) {
            return LongMath.divide((long)((Long)trinoNativeValue), (long)1000000L, (RoundingMode)RoundingMode.UNNECESSARY);
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
            return (long)((Long)trinoNativeValue);
        }
        if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            return Timestamps.timestampTzToMicros((LongTimestampWithTimeZone)trinoNativeValue);
        }
        if (type instanceof VarcharType) {
            return ((Slice)trinoNativeValue).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return ByteBuffer.wrap(((Slice)trinoNativeValue).getBytes());
        }
        if (type == UuidType.UUID) {
            return UuidType.trinoUuidToJavaUuid((Slice)((Slice)trinoNativeValue));
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    public static Object convertIcebergValueToTrino(Type icebergType, Object value) {
        if (value == null) {
            return null;
        }
        if (icebergType instanceof Types.BooleanType) {
            return (boolean)((Boolean)value);
        }
        if (icebergType instanceof Types.IntegerType) {
            return (long)((Integer)value).intValue();
        }
        if (icebergType instanceof Types.LongType) {
            return (long)((Long)value);
        }
        if (icebergType instanceof Types.FloatType) {
            return (long)Float.floatToIntBits(((Float)value).floatValue());
        }
        if (icebergType instanceof Types.DoubleType) {
            return (double)((Double)value);
        }
        if (icebergType instanceof Types.DecimalType) {
            Types.DecimalType icebergDecimalType = (Types.DecimalType)icebergType;
            DecimalType trinoDecimalType = DecimalType.createDecimalType((int)icebergDecimalType.precision(), (int)icebergDecimalType.scale());
            if (trinoDecimalType.isShort()) {
                return Decimals.encodeShortScaledValue((BigDecimal)((BigDecimal)value), (int)trinoDecimalType.getScale());
            }
            return Decimals.encodeScaledValue((BigDecimal)((BigDecimal)value), (int)trinoDecimalType.getScale());
        }
        if (icebergType instanceof Types.StringType) {
            if (value instanceof CharBuffer) {
                value = new String(((CharBuffer)value).array());
            }
            return Slices.utf8Slice((String)((String)value));
        }
        if (icebergType instanceof Types.BinaryType) {
            return Slices.wrappedBuffer((byte[])((byte[])ByteBuffers.getWrappedBytes((ByteBuffer)((ByteBuffer)value)).clone()));
        }
        if (icebergType instanceof Types.DateType) {
            return (long)((Integer)value).intValue();
        }
        if (icebergType instanceof Types.TimeType) {
            return Math.multiplyExact((long)((Long)value), 1000000);
        }
        if (icebergType instanceof Types.TimestampType) {
            Types.TimestampType icebergTimestampType = (Types.TimestampType)icebergType;
            long epochMicros = (Long)value;
            if (icebergTimestampType.shouldAdjustToUTC()) {
                return Timestamps.timestampTzFromMicros(epochMicros);
            }
            return epochMicros;
        }
        if (icebergType instanceof Types.UUIDType) {
            return UuidType.javaUuidToTrinoUuid((UUID)((UUID)value));
        }
        throw new UnsupportedOperationException("Unsupported iceberg type: " + String.valueOf(icebergType));
    }
}

