/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.type.VarcharType;

public class IcebergUpdateBucketFunction
implements BucketFunction {
    private final int bucketCount;

    public IcebergUpdateBucketFunction(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        SqlRow row = (SqlRow)page.getBlock(0).getObject(position, SqlRow.class);
        Slice value = VarcharType.VARCHAR.getSlice(row.getRawFieldBlock(0), row.getRawIndex());
        return (value.hashCode() & Integer.MAX_VALUE) % this.bucketCount;
    }
}

